/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.metadata;

import com.exadel.aem.toolkit.api.annotations.meta.AnnotationRendering;
import com.exadel.aem.toolkit.api.annotations.meta.IgnorePropertyMapping;
import com.exadel.aem.toolkit.api.annotations.meta.PropertyMapping;
import com.exadel.aem.toolkit.plugin.utils.ArrayUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class RenderingFilter
implements Predicate<Method> {
    public static final Predicate<?> EMPTY = arg -> true;
    private final List<String> mappings;

    public RenderingFilter(Annotation annotation) {
        this.mappings = RenderingFilter.getMappings(annotation);
    }

    @Override
    public boolean test(Method value) {
        return this.test(value.getName(), value.getAnnotation(IgnorePropertyMapping.class) != null);
    }

    private boolean test(String name, boolean ignoreMappingIsSet) {
        if (this.mappings.isEmpty() || this.mappings.contains("none")) {
            return false;
        }
        if (this.mappings.stream().anyMatch(mapping -> !mapping.startsWith("!") && !"*".equals(mapping))) {
            return this.mappings.contains(name) && !ignoreMappingIsSet;
        }
        return this.mappings.stream().noneMatch(mapping -> mapping.equals("!" + name)) && this.mappings.contains("*");
    }

    private static List<String> getMappings(Annotation annotation) {
        Stream mappingsByPropertyMapping;
        Stream mappingsByAnnotationRendering = Optional.ofNullable(annotation).map(Annotation::annotationType).map(annotationType -> annotationType.getAnnotation(AnnotationRendering.class)).map(AnnotationRendering::properties).map(ArrayUtil::flatten).map(Arrays::stream).orElse(Stream.empty());
        List cumulativeMappings = Stream.concat(mappingsByAnnotationRendering, mappingsByPropertyMapping = Optional.ofNullable(annotation).map(Annotation::annotationType).map(annotationType -> annotationType.getAnnotation(PropertyMapping.class)).map(PropertyMapping::mappings).map(ArrayUtil::flatten).map(Arrays::stream).orElse(Stream.empty())).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (cumulativeMappings.stream().allMatch(mapping -> mapping.startsWith("!"))) {
            cumulativeMappings.add("*");
        }
        return cumulativeMappings.stream().map(mapping -> "all".equals(mapping) ? "*" : mapping).distinct().collect(Collectors.toList());
    }
}

