/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.metadata.scripting;

import com.exadel.aem.toolkit.plugin.metadata.scripting.AbstractAdapter;
import com.exadel.aem.toolkit.plugin.metadata.scripting.Annotated;
import com.exadel.aem.toolkit.plugin.metadata.scripting.ListAdapter;
import com.exadel.aem.toolkit.plugin.metadata.scripting.MemberAdapter;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class ClassAdapter
extends AbstractAdapter
implements Annotated,
Callable {
    private static final String METHOD_ANCESTORS = "ancestors";
    private static final String METHOD_MEMBER = "member";
    private static final String METHOD_PARENT = "parent";
    private final Class<?> reflectedClass;

    ClassAdapter(Class<?> value) {
        this.reflectedClass = value;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.reflectedClass;
    }

    public Object get(String name, Scriptable start) {
        if ("name".equals(name)) {
            return this.getName();
        }
        if (METHOD_PARENT.equals(name)) {
            return this.reflectedClass.getSuperclass() != null ? new ClassAdapter(this.reflectedClass.getSuperclass()) : null;
        }
        if (METHOD_ANCESTORS.equals(name)) {
            return this::getAncestors;
        }
        if ("annotation".equals(name)) {
            return (context, scope, thisObj, args) -> this.getAnnotation(args);
        }
        if ("annotations".equals(name)) {
            return (context, scope, thisObj, args) -> this.getAnnotations(args);
        }
        if (METHOD_MEMBER.equals(name)) {
            return this::getMember;
        }
        return super.get(name, start);
    }

    public String getName() {
        return this.reflectedClass.getSimpleName();
    }

    private Object getAncestors(Context context, Scriptable scope, Scriptable thisObj, Object[] args) {
        List classAdapters = ClassUtil.getInheritanceTree(this.reflectedClass, false).stream().map(ClassAdapter::new).collect(Collectors.toList());
        return new ListAdapter<ClassAdapter>(classAdapters, (adapter, name) -> StringUtils.equals((CharSequence)adapter.getName(), (CharSequence)String.valueOf(name)));
    }

    private Object getMember(Context context, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args == null || args.length < 1 || args[0] == null) {
            return null;
        }
        String name = String.valueOf(args[0]);
        try {
            return new MemberAdapter(this.reflectedClass.getDeclaredField(name));
        }
        catch (NoSuchFieldException nsf) {
            try {
                return new MemberAdapter(this.reflectedClass.getDeclaredMethod(name, new Class[0]));
            }
            catch (NoSuchMethodException nsm) {
                return null;
            }
        }
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        if (String.class.equals(typeHint)) {
            return this.reflectedClass.getName();
        }
        return super.getDefaultValue(typeHint);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return this;
    }
}

