/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.metadata.scripting;

import com.exadel.aem.toolkit.plugin.metadata.scripting.AbstractAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

class ListAdapter<T>
extends AbstractAdapter {
    private static final String METHOD_INCLUDES = "includes";
    private final List<T> items = new ArrayList<T>();
    private final BiPredicate<T, Object> matcher;

    ListAdapter(List<T> items) {
        this(items, null);
    }

    ListAdapter(List<T> items, BiPredicate<T, Object> matcher) {
        this.items.addAll(items);
        this.matcher = matcher;
    }

    @Override
    public String getClassName() {
        return ListAdapter.class.getSimpleName();
    }

    public Object get(String name, Scriptable start) {
        if (METHOD_INCLUDES.equals(name)) {
            return this::includes;
        }
        return super.get(name, start);
    }

    public Object get(int index, Scriptable start) {
        return index >= 0 && index < this.items.size() ? this.items.get(index) : Undefined.SCRIPTABLE_UNDEFINED;
    }

    public void put(int index, Scriptable start, Object value) {
        if (index >= 0 && index < this.items.size()) {
            this.items.set(index, value);
        }
    }

    public Object includes(Context context, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args == null || args.length < 1) {
            return false;
        }
        if (this.matcher == null) {
            return this.items.contains(args[0]);
        }
        return this.items.stream().anyMatch(item -> this.matcher.test(item, args[0]));
    }
}

