/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.metadata.scripting;

import com.exadel.aem.toolkit.plugin.metadata.scripting.AbstractAdapter;
import com.exadel.aem.toolkit.plugin.metadata.scripting.Annotated;
import com.exadel.aem.toolkit.plugin.metadata.scripting.ClassAdapter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class MemberAdapter
extends AbstractAdapter
implements Annotated,
Callable {
    private static final String PN_CLASS = "class";
    private static final String PN_CONTEXT = "context";
    private static final String PN_UPSTREAM = "upstream";
    private final Member reflectedMember;
    private final Member upstreamMember;
    private final Object declaringClass;

    MemberAdapter(Member value) {
        this(value, null, null);
    }

    MemberAdapter(Member reflectedMember, Member upstreamMember, Object declaringClass) {
        this.reflectedMember = reflectedMember;
        this.upstreamMember = upstreamMember;
        this.declaringClass = declaringClass;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return (AnnotatedElement)((Object)this.reflectedMember);
    }

    public Object get(String name, Scriptable start) {
        if ("name".equals(name)) {
            return this.reflectedMember.getName();
        }
        if (PN_CLASS.equals(name) && this.reflectedMember.getDeclaringClass() != null) {
            return new ClassAdapter(this.reflectedMember.getDeclaringClass());
        }
        if (StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{PN_CONTEXT, PN_UPSTREAM}) && this.upstreamMember != null) {
            return new MemberAdapter(this.upstreamMember);
        }
        if ("annotation".equals(name)) {
            return (context, scope, thisObj, args) -> this.getAnnotation(args);
        }
        if ("annotations".equals(name)) {
            return (context, scope, thisObj, args) -> this.getAnnotations(args);
        }
        return super.get(name, start);
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        if (String.class.equals(typeHint)) {
            return this.reflectedMember.getName();
        }
        return super.getDefaultValue(typeHint);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!(this.reflectedMember instanceof Method)) {
            return null;
        }
        try {
            return ((Method)this.reflectedMember).invoke(this.declaringClass, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }
}

