/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.metadata.scripting;

import com.exadel.aem.toolkit.api.handlers.EmbeddedMemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.plugin.exceptions.ScriptingException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.Property;
import com.exadel.aem.toolkit.plugin.metadata.scripting.AbstractAdapter;
import com.exadel.aem.toolkit.plugin.metadata.scripting.ClassAdapter;
import com.exadel.aem.toolkit.plugin.metadata.scripting.DataStack;
import com.exadel.aem.toolkit.plugin.metadata.scripting.MapAdapter;
import com.exadel.aem.toolkit.plugin.metadata.scripting.MemberAdapter;
import com.exadel.aem.toolkit.plugin.metadata.scripting.SubstringMatcher;
import com.exadel.aem.toolkit.plugin.sources.ModifiableMemberSource;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class ScriptingHelper {
    private static final ContextFactory CONTEXT_FACTORY = new ContextFactory();
    private static final ClassShutter DEFAULT_CLASS_SHUTTER = className -> StringUtils.startsWith((CharSequence)className, (CharSequence)"com.exadel.aem.toolkit");
    private static final String PN_SETTINGS = "settings";
    private static final String PN_SOURCE = "source";
    private static final String PATH_SCRIPT = "<script>";
    private static final String TEMPLATE_START = "$";
    private static final String TEMPLATE_STRIPPED_SYMBOLS = "@${} ";
    private static final String TOKEN_THIS = "this";

    private ScriptingHelper() {
    }

    public static synchronized void interpolate(Metadata value, Source source) {
        if (value == null) {
            return;
        }
        List templatedProperties = value.stream(true, true).map(TemplatedProperty::from).filter(Objects::nonNull).collect(Collectors.toList());
        if (templatedProperties.isEmpty()) {
            return;
        }
        AbstractAdapter adapter = ScriptingHelper.getAdapter(source);
        if (adapter == null) {
            return;
        }
        DataStack dataStack = (DataStack)source.adaptTo(DataStack.class);
        try (Context context = CONTEXT_FACTORY.enterContext();){
            context.setLanguageVersion(200);
            context.setClassShutter(DEFAULT_CLASS_SHUTTER);
            ScriptableObject scope = context.initStandardObjects();
            ScriptableObject.putProperty((Scriptable)scope, (String)PN_SOURCE, (Object)Context.javaToJS((Object)((Object)adapter), (Scriptable)scope));
            ScriptableObject.putProperty((Scriptable)scope, (String)PN_SETTINGS, (Object)Context.javaToJS((Object)((Object)new MapAdapter(dataStack.getData())), (Scriptable)scope));
            for (TemplatedProperty property : templatedProperties) {
                String result = ScriptingHelper.interpolate(property, context, (Scriptable)scope, dataStack);
                value.putValue(property.getPath(), (Object)result);
            }
        }
        catch (IllegalStateException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ScriptingException(e));
        }
    }

    private static String interpolate(TemplatedProperty templatedProperty, Context context, Scriptable scope, DataStack dataStack) {
        String result = templatedProperty.getValue();
        while (!templatedProperty.getEmbeddings().isEmpty()) {
            StringBuilder resultBuilder = new StringBuilder(templatedProperty.getValue());
            LinkedList embeddings = (LinkedList)templatedProperty.getEmbeddings();
            Iterator embeddingIterator = embeddings.descendingIterator();
            while (embeddingIterator.hasNext()) {
                Embedding embedding = (Embedding)embeddingIterator.next();
                List<String> variables = embedding.getVariables();
                for (String variable : variables) {
                    if (TOKEN_THIS.equals(variable)) continue;
                    Object value = dataStack.getData().get(variable);
                    ScriptableObject.putProperty((Scriptable)scope, (String)variable, (Object)(value != null ? Context.javaToJS((Object)value, (Scriptable)scope) : Undefined.instance));
                }
                String scriptResult = ScriptingHelper.runScript(context, scope, embedding.getScript());
                resultBuilder.replace(embedding.getStart(), embedding.getEnd(), scriptResult);
            }
            result = resultBuilder.toString();
            templatedProperty.reset(result);
        }
        return result;
    }

    private static AbstractAdapter getAdapter(Source source) {
        if (source.adaptTo(Member.class) != null) {
            Member reflectedMember = (Member)source.adaptTo(Member.class);
            Member reflectedUpstreamMember = source.tryAdaptTo(ModifiableMemberSource.class).map(EmbeddedMemberSource::getUpstreamMember).orElse(null);
            return new MemberAdapter(reflectedMember, reflectedUpstreamMember, null);
        }
        if (source.adaptTo(Class.class) != null) {
            return new ClassAdapter((Class)source.adaptTo(Class.class));
        }
        return null;
    }

    private static String runScript(Context context, Scriptable scope, String script) {
        try {
            Object result = context.evaluateString(scope, script, PATH_SCRIPT, 0, null);
            result = Context.jsToJava((Object)result, String.class);
            return result != null && !Undefined.SCRIPTABLE_UNDEFINED.toString().equals(result.toString()) ? result.toString() : "";
        }
        catch (RhinoException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ScriptingException((Exception)((Object)e)));
            return "";
        }
    }

    private static class Embedding {
        private final SubstringMatcher.Substring substring;
        private final LinkedList<SubstringMatcher.Substring> varTokens;

        Embedding(SubstringMatcher.Substring substring) {
            this.substring = substring;
            this.varTokens = Embedding.findVariableTokens(substring.getContent());
        }

        public int getStart() {
            return this.substring.getStart();
        }

        public int getEnd() {
            return this.substring.getEnd();
        }

        public boolean isJavaScript() {
            return this.substring.getContent().startsWith("@") || !this.varTokens.isEmpty();
        }

        public String getScript() {
            String result = this.substring.getContent();
            if (!this.varTokens.isEmpty()) {
                StringBuilder resultBuilder = new StringBuilder(result);
                this.varTokens.descendingIterator().forEachRemaining(token -> resultBuilder.replace(token.getStart(), token.getEnd(), token.getContent().substring(1)));
                result = resultBuilder.toString();
            }
            return StringUtils.strip((String)result.replace(ScriptingHelper.TOKEN_THIS, ScriptingHelper.PN_SOURCE), (String)ScriptingHelper.TEMPLATE_STRIPPED_SYMBOLS);
        }

        public List<String> getVariables() {
            return this.varTokens.stream().map(token -> token.getContent().substring(1)).collect(Collectors.toList());
        }

        private static LinkedList<SubstringMatcher.Substring> findVariableTokens(String expression) {
            LinkedList<SubstringMatcher.Substring> result = new LinkedList<SubstringMatcher.Substring>();
            SubstringMatcher substringMatcher = new SubstringMatcher(expression, "@");
            SubstringMatcher.Substring newSubstring = substringMatcher.next();
            while (newSubstring != null) {
                result.add(newSubstring);
                newSubstring = substringMatcher.next();
            }
            return result;
        }
    }

    private static class TemplatedProperty {
        private String path;
        private String value;
        private LinkedList<Embedding> embeddings;

        private TemplatedProperty() {
        }

        public String getPath() {
            return this.path;
        }

        public String getValue() {
            return this.value;
        }

        public List<Embedding> getEmbeddings() {
            return this.embeddings;
        }

        public void reset(String content) {
            this.value = content;
            this.embeddings = new LinkedList();
            SubstringMatcher substringMatcher = new SubstringMatcher(this.value, "{", "}", Arrays.asList(ScriptingHelper.TEMPLATE_START, "@"));
            SubstringMatcher.Substring substring = substringMatcher.next();
            while (substring != null) {
                Embedding embedding = new Embedding(substring);
                if (embedding.isJavaScript()) {
                    this.embeddings.add(embedding);
                }
                substring = substringMatcher.next();
            }
        }

        public static TemplatedProperty from(Property original) {
            boolean hasDollarSignTemplate;
            if (!String.class.equals(original.getType())) {
                return null;
            }
            Object value = original.getValue();
            String stringValue = value != null ? value.toString() : null;
            boolean hasAtTemplate = stringValue != null && stringValue.contains("@{");
            boolean bl = hasDollarSignTemplate = stringValue != null && stringValue.contains("${");
            if (!hasAtTemplate && !hasDollarSignTemplate) {
                return null;
            }
            TemplatedProperty result = new TemplatedProperty();
            result.path = original.getPath();
            result.reset(stringValue);
            return !result.getEmbeddings().isEmpty() ? result : null;
        }
    }
}

