/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.metadata.scripting;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

class SubstringMatcher {
    private static final List<Character> QUOTE_CHARS = Arrays.asList(Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('`'));
    private static final char ESCAPE_CHAR = '\\';
    private final String source;
    private final String startToken;
    private final String endToken;
    private final List<String> prefixes;
    private String lastMatch;
    private int cursor;

    SubstringMatcher(String source, String marker) {
        this(source, marker, null);
    }

    SubstringMatcher(String source, String startToken, String endToken) {
        this(source, startToken, endToken, null);
    }

    SubstringMatcher(String source, String startToken, String endToken, List<String> prefixes) {
        this.source = source;
        this.startToken = startToken;
        this.endToken = endToken;
        this.prefixes = prefixes;
    }

    public Substring next() {
        Substring nextSubstring;
        if (this.cursor > this.source.length() || StringUtils.isEmpty((CharSequence)this.startToken)) {
            return null;
        }
        Substring substring = nextSubstring = this.endToken != null ? this.nextSubstring() : this.nextWord();
        if (nextSubstring == null) {
            return null;
        }
        if (this.prefixes != null) {
            String activePrefix = this.prefixes.stream().filter(prefix -> nextSubstring.getStart() >= prefix.length() && this.source.startsWith((String)prefix, nextSubstring.getStart() - prefix.length())).findFirst().orElse(null);
            if (activePrefix == null) {
                return this.next();
            }
            boolean isNotEscaped = nextSubstring.getStart() - activePrefix.length() == 0 || this.source.charAt(nextSubstring.getStart() - activePrefix.length() - 1) != '\\';
            return isNotEscaped ? nextSubstring.adjustStart(nextSubstring.getStart() - activePrefix.length()) : this.next();
        }
        return nextSubstring.getStart() == 0 || this.source.charAt(nextSubstring.getStart() - 1) != '\\' ? nextSubstring : this.next();
    }

    private Substring nextSubstring() {
        this.advanceBeyond(this.startToken);
        if (this.cursor > this.source.length()) {
            return null;
        }
        int startPosition = this.cursor - this.lastMatch.length();
        int numOfStartTokens = 1;
        int numOfEndTokens = 0;
        while (numOfStartTokens != numOfEndTokens) {
            this.advanceBeyond(this.startToken, this.endToken);
            if (this.cursor > this.source.length()) {
                return null;
            }
            if (StringUtils.equalsAny((CharSequence)this.lastMatch, (CharSequence[])new CharSequence[]{this.startToken})) {
                ++numOfStartTokens;
                continue;
            }
            ++numOfEndTokens;
        }
        return new Substring(this.source, startPosition, this.cursor);
    }

    private Substring nextWord() {
        int endPosition;
        this.advanceBeyond(this.startToken);
        if (this.cursor > this.source.length()) {
            return null;
        }
        int startPosition = this.cursor - this.lastMatch.length();
        for (endPosition = this.cursor; endPosition < this.source.length() && (Character.isLetterOrDigit(this.source.charAt(endPosition)) || this.source.charAt(endPosition) == '_'); ++endPosition) {
        }
        this.cursor = endPosition;
        if (endPosition - startPosition == this.lastMatch.length()) {
            return this.nextWord();
        }
        return new Substring(this.source, startPosition, endPosition);
    }

    private void advanceBeyond(String ... anyOfTokens) {
        char activeQuote;
        int pairedQuotePosition;
        Pair nextToken = Arrays.stream(anyOfTokens).map(token -> Pair.of((Object)token, (Object)this.source.indexOf((String)token, this.cursor))).filter(pair -> (Integer)pair.getRight() >= this.cursor).min(Comparator.comparingInt(Pair::getRight)).orElse(null);
        if (nextToken == null) {
            this.cursor = this.source.length() + 1;
            this.lastMatch = null;
            return;
        }
        int quotePosition = QUOTE_CHARS.stream().mapToInt(chr -> this.source.indexOf(chr.charValue(), this.cursor)).filter(index -> index >= this.cursor).min().orElse(-1);
        if (quotePosition >= this.cursor && quotePosition < (Integer)nextToken.getRight() && (pairedQuotePosition = this.source.indexOf(activeQuote = this.source.charAt(quotePosition), quotePosition + 1)) > quotePosition && (Integer)nextToken.getRight() < pairedQuotePosition) {
            this.cursor = pairedQuotePosition + 1;
            this.advanceBeyond(anyOfTokens);
            return;
        }
        this.lastMatch = (String)nextToken.getLeft();
        this.cursor = ((String)nextToken.getLeft()).length() + (Integer)nextToken.getRight();
    }

    public static class Substring {
        private final String source;
        private int start;
        private final int end;

        Substring(String source, int start, int endIndex) {
            this.source = source;
            this.start = start;
            this.end = endIndex;
        }

        public int getStart() {
            return this.start;
        }

        private Substring adjustStart(int value) {
            this.start = value;
            return this;
        }

        public int getEnd() {
            return this.end;
        }

        public String getContent() {
            return this.source.substring(this.start, this.end);
        }
    }
}

