/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.runtime;

import com.exadel.aem.toolkit.api.annotations.main.AemComponent;
import com.exadel.aem.toolkit.api.annotations.main.Dialog;
import com.exadel.aem.toolkit.api.annotations.meta.AnnotationRendering;
import com.exadel.aem.toolkit.api.annotations.meta.Validator;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Handles;
import com.exadel.aem.toolkit.api.handlers.HandlesWidgets;
import com.exadel.aem.toolkit.api.runtime.Injected;
import com.exadel.aem.toolkit.api.runtime.RuntimeContext;
import com.exadel.aem.toolkit.plugin.exceptions.ExtensionApiException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.sources.ComponentSource;
import com.exadel.aem.toolkit.plugin.sources.Sources;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import com.exadel.aem.toolkit.plugin.utils.ScopeUtil;
import com.exadel.aem.toolkit.plugin.utils.ordering.OrderingUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;

public class ReflectionContextHelper {
    private static final char SEPARATOR_COMMA = ',';
    private Reflections reflections;
    private ClassLoader classLoader;
    private List<ComponentSource> components;
    private List<Handler> handlers;
    private List<Validator> validators;

    private ReflectionContextHelper() {
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<ComponentSource> getComponents(String packageBase) {
        String[] packageRoots = StringUtils.split((String)packageBase, (char)',');
        return this.getComponents().stream().filter(comp -> StringUtils.isEmpty((CharSequence)packageBase) || ClassUtil.matchesReference((Class)comp.adaptTo(Class.class), packageRoots)).collect(Collectors.toList());
    }

    private List<ComponentSource> getComponents() {
        if (this.components != null) {
            return this.components;
        }
        HashSet classesAnnotatedWithComponent = new HashSet(this.reflections.getTypesAnnotatedWith(AemComponent.class, true));
        HashSet classesAnnotatedWithDialog = new HashSet(this.reflections.getTypesAnnotatedWith(Dialog.class, true));
        HashSet componentViews = new HashSet();
        classesAnnotatedWithComponent.forEach(cls -> componentViews.addAll(Arrays.asList(cls.getAnnotation(AemComponent.class).views())));
        classesAnnotatedWithComponent.addAll(classesAnnotatedWithDialog.stream().filter(cls -> !componentViews.contains(cls)).collect(Collectors.toList()));
        this.components = classesAnnotatedWithComponent.stream().map(Sources::fromComponentClass).collect(Collectors.toList());
        return this.components;
    }

    public ComponentSource getComponent(Class<?> componentClass) {
        return this.getComponents().stream().filter(comp -> comp.matches(componentClass)).findFirst().orElse(null);
    }

    public ComponentSource getComponent(String path) {
        return this.getComponents().stream().filter(comp -> comp.matches(path)).findFirst().orElse(null);
    }

    public boolean isHandled(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(AnnotationRendering.class) || this.getHandlers().stream().anyMatch(handler -> ReflectionContextHelper.isHandlerMatches(handler, null, new Class[]{annotation.annotationType()}));
    }

    public List<Handler> getHandlers(String scope, Annotation[] annotations) {
        List result = this.getHandlers().stream().filter(handler -> ReflectionContextHelper.isHandlerMatches(handler, scope, annotations)).collect(Collectors.toList());
        return OrderingUtil.sortHandlers(result);
    }

    public List<Handler> getHandlers(String scope, Class<?> ... annotationTypes) {
        List result = this.getHandlers().stream().filter(handler -> ReflectionContextHelper.isHandlerMatches(handler, scope, annotationTypes)).collect(Collectors.toList());
        return OrderingUtil.sortHandlers(result);
    }

    public List<Handler> getHandlers() {
        if (this.handlers != null) {
            return this.handlers;
        }
        this.handlers = this.reflections.getSubTypesOf(Handler.class).stream().filter(cls -> !cls.isInterface()).map(ReflectionContextHelper::getHandlerInstance).filter(Objects::nonNull).sorted(OrderingUtil::compareByOrigin).collect(Collectors.toList());
        return this.handlers;
    }

    private static boolean isHandlerMatches(Handler handler, String scope, Annotation[] annotations) {
        return ReflectionContextHelper.isHandlerMatches(handler, scope, (Class[])Arrays.stream(annotations).map(Annotation::annotationType).toArray(Class[]::new));
    }

    private static boolean isHandlerMatches(Handler handler, String scope, Class<?>[] annotationTypes) {
        String[] stringArray;
        Handles handles = handler.getClass().getDeclaredAnnotation(Handles.class);
        HandlesWidgets handlesWidgets = handler.getClass().getDeclaredAnnotation(HandlesWidgets.class);
        if (handles == null && handlesWidgets == null) {
            return false;
        }
        Class[] handledAnnotationTypes = handles != null ? handles.value() : handlesWidgets.value();
        boolean isMatchByType = Arrays.stream(handledAnnotationTypes).anyMatch(annotationType -> Arrays.asList(annotationTypes).contains(annotationType));
        if (handles != null) {
            stringArray = handles.scope();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] handlerScopes = stringArray;
        if (handles != null && handlerScopes.length == 1 && handlerScopes[0].equals("")) {
            handlerScopes = ScopeUtil.designate(handles.value());
        }
        if (handlerScopes.length == 1 && handlerScopes[0].equals("")) {
            handlerScopes = ScopeUtil.designate(annotationTypes);
        }
        boolean isMatchByScope = scope == null || ScopeUtil.fits(scope, handlerScopes);
        return isMatchByType && isMatchByScope;
    }

    private static <T> T getHandlerInstance(Class<? extends T> handlerClass) {
        Object instance = ReflectionContextHelper.getInstance(handlerClass);
        if (instance != null) {
            Arrays.stream(handlerClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Injected.class) && ClassUtils.isAssignable(field.getType(), RuntimeContext.class)).forEach(field -> ReflectionContextHelper.populateRuntimeContext(instance, field));
        }
        return instance;
    }

    private static void populateRuntimeContext(Object handler, Field field) {
        field.setAccessible(true);
        try {
            field.set(handler, PluginRuntime.context());
        }
        catch (IllegalAccessException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ExtensionApiException(handler.getClass(), e));
        }
    }

    public List<Validator> getValidators() {
        if (this.validators != null) {
            return this.validators;
        }
        this.validators = this.reflections.getSubTypesOf(Validator.class).stream().map(ReflectionContextHelper::getInstance).filter(Objects::nonNull).collect(Collectors.toList());
        return this.validators;
    }

    private static <T> T getInstance(Class<? extends T> instanceClass) {
        try {
            return instanceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ExtensionApiException(instanceClass, ex));
            return null;
        }
    }

    public static ReflectionContextHelper fromCodeScope(List<String> elements) {
        URL[] urls = new URL[]{};
        if (elements != null) {
            urls = (URL[])elements.stream().map(File::new).map(File::toURI).map(ReflectionContextHelper::toUrl).filter(Objects::nonNull).toArray(URL[]::new);
        }
        URLClassLoader classLoader = new URLClassLoader(urls, ReflectionContextHelper.class.getClassLoader());
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addClassLoader((ClassLoader)classLoader).setUrls(urls).setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()}));
        ReflectionContextHelper newInstance = new ReflectionContextHelper();
        newInstance.classLoader = classLoader;
        newInstance.reflections = reflections;
        return newInstance;
    }

    private static URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)e);
            return null;
        }
    }
}

