/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.runtime;

import com.exadel.aem.toolkit.api.annotations.meta.AnnotationRendering;
import com.exadel.aem.toolkit.api.annotations.meta.PropertyMapping;
import com.exadel.aem.toolkit.api.annotations.meta.PropertyRendering;
import com.exadel.aem.toolkit.api.annotations.widgets.attribute.Data;
import com.exadel.aem.toolkit.api.runtime.XmlUtility;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.Property;
import com.exadel.aem.toolkit.plugin.metadata.RenderingFilter;
import com.exadel.aem.toolkit.plugin.targets.AttributeHelper;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import com.exadel.aem.toolkit.plugin.utils.StringUtil;
import com.exadel.aem.toolkit.plugin.validators.Validation;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlContextHelper
implements XmlUtility {
    private static final BinaryOperator<String> DEFAULT_ATTRIBUTE_MERGER = (first, second) -> {
        if (StringUtils.isNotBlank((CharSequence)first) && StringUtils.isBlank((CharSequence)second)) {
            return first;
        }
        return StringUtils.isNotEmpty((CharSequence)second) ? second : first;
    };
    private final Document document;

    public XmlContextHelper(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element createNodeElement(String name, String nodeType, Map<String, String> properties, String resourceType) {
        Element element = this.getDocument().createElement(this.getValidName(name));
        if (nodeType == null) {
            nodeType = "nt:unstructured";
        }
        element.setAttribute("jcr:primaryType", nodeType);
        if (resourceType != null) {
            element.setAttribute("sling:resourceType", resourceType);
        }
        if (properties != null) {
            properties.forEach((key, value) -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value})) {
                    element.setAttribute((String)key, (String)value);
                }
            });
        }
        return element;
    }

    public Element createNodeElement(String name, String nodeType, Map<String, String> properties) {
        return this.createNodeElement(name, nodeType, properties, null);
    }

    public Element createNodeElement(String name, Map<String, String> properties, String resourceType) {
        return this.createNodeElement(name, null, properties, resourceType);
    }

    public Element createNodeElement(String name, String resourceType) {
        return this.createNodeElement(name, null, new HashMap<String, String>(), resourceType);
    }

    public Element createNodeElement(String name, Map<String, String> properties) {
        return this.createNodeElement(name, null, properties);
    }

    public Element createNodeElement(String name) {
        return this.createNodeElement(name, null, new HashMap<String, String>());
    }

    public Element createNodeElement(String name, Annotation source) {
        return this.createNodeElement((Annotation annotation) -> name, source);
    }

    private Element createNodeElement(Function<Annotation, String> nameProvider, Annotation source) {
        if (!Validation.forType(source.annotationType()).test(source)) {
            return null;
        }
        Element newNode = this.createNodeElement(nameProvider.apply(source));
        Metadata.from(source).forEach(property -> AttributeHelper.forXmlTarget().forAnnotationProperty(source, (Property)property).setTo(newNode));
        return newNode;
    }

    public String getValidName(String name) {
        return NamingUtil.getValidNodeName(name, "item");
    }

    public String getValidSimpleName(String name) {
        return NamingUtil.getValidNodeName(name, "item");
    }

    public String getValidFieldName(String name) {
        return NamingUtil.getValidNodeName(name, "field");
    }

    public String getUniqueName(String name, String defaultValue, Element context) {
        return NamingUtil.getUniqueName(name, defaultValue, context);
    }

    public void setAttribute(Element element, String name, Double value) {
        AttributeHelper.forXmlTarget().forNamedValue(name, Double.class).setValue(value, element);
    }

    public void setAttribute(Element element, String name, Long value) {
        AttributeHelper.forXmlTarget().forNamedValue(name, Long.class).setValue(value, element);
    }

    public void setAttribute(Element element, String name, Boolean value) {
        AttributeHelper.forXmlTarget().forNamedValue(name, Boolean.class).setValue(value, element);
    }

    public void setAttribute(Element element, String name, String value) {
        AttributeHelper.forXmlTarget().forNamedValue(name, String.class).setValue(value, element);
    }

    public void setAttribute(Element element, String name, List<String> values) {
        this.setAttribute(element, name, values, XmlContextHelper::mergeStringAttributes);
    }

    public void setAttribute(Element element, String name, List<String> values, BinaryOperator<String> attributeMerger) {
        AttributeHelper.forXmlTarget().forNamedValue(name, String.class).withMerger(attributeMerger).setValue(values, element);
    }

    public void setAttribute(Element element, String name, Annotation source) {
        this.setAttribute(element, name, source, DEFAULT_ATTRIBUTE_MERGER);
    }

    public void setAttribute(Element element, String name, Annotation source, BinaryOperator<String> attributeMerger) {
        XmlContextHelper.setAttribute(() -> element, name, source, attributeMerger);
    }

    public void setAttribute(Supplier<Element> elementSupplier, String name, Annotation source) {
        XmlContextHelper.setAttribute(elementSupplier, name, source, DEFAULT_ATTRIBUTE_MERGER);
    }

    private static void setAttribute(Supplier<Element> elementSupplier, String name, Annotation source, BinaryOperator<String> attributeMerger) {
        Property property = Metadata.from(source).stream().filter(prop -> StringUtils.equals((CharSequence)name, (CharSequence)prop.getName())).findFirst().orElse(null);
        if (property == null || property.valueIsDefault()) {
            return;
        }
        PropertyRendering propertyRendering = property.getAnnotation(PropertyRendering.class);
        String effectiveName = name;
        if (propertyRendering != null) {
            effectiveName = (String)StringUtils.defaultIfBlank((CharSequence)propertyRendering.name(), (CharSequence)name);
        }
        AttributeHelper.forXmlTarget().forAnnotationProperty(source, property).withName(effectiveName).withMerger(attributeMerger).setTo(elementSupplier.get());
    }

    public void mapProperties(Element element, Annotation annotation) {
        this.mapProperties(element, annotation, Collections.emptyList());
    }

    public void mapProperties(Element element, Annotation annotation, String scope) {
        List<String> skippedFields = Metadata.from(annotation).stream().filter(prop -> !XmlContextHelper.fitsInScope(prop, scope)).map(Property::getName).collect(Collectors.toList());
        this.mapProperties(element, annotation, skippedFields);
    }

    public void mapProperties(Element element, Annotation annotation, List<String> skipped) {
        Annotation prefixHolder = Metadata.from(annotation).getAnyAnnotation(AnnotationRendering.class, PropertyMapping.class);
        if (prefixHolder == null) {
            return;
        }
        String prefix = String.valueOf(Metadata.from(prefixHolder).getValue("prefix"));
        String nodePrefix = prefix.contains("/") ? StringUtils.substringBeforeLast((String)prefix, (String)"/") : "";
        Element effectiveElement = this.getRequiredElement(element, nodePrefix);
        RenderingFilter renderingFilter = new RenderingFilter(annotation);
        Metadata.from(annotation).stream().filter(property -> property.matches(renderingFilter)).filter(property -> !skipped.contains(property.getName())).forEach(property -> XmlContextHelper.populateProperty(property, nodePrefix, effectiveElement, annotation));
    }

    private static void populateProperty(Property property, String prefix, Element element, Annotation annotation) {
        String name = property.getName();
        boolean ignorePrefix = false;
        PropertyRendering propertyRendering = property.getAnnotation(PropertyRendering.class);
        if (propertyRendering != null) {
            name = (String)StringUtils.defaultIfBlank((CharSequence)propertyRendering.name(), (CharSequence)name);
            ignorePrefix = propertyRendering.ignorePrefix();
        }
        if (!ignorePrefix && StringUtils.isNotBlank((CharSequence)prefix)) {
            name = prefix + name;
        }
        BinaryOperator merger = XmlContextHelper::mergeStringAttributes;
        AttributeHelper.forXmlTarget().forAnnotationProperty(annotation, property).withName(name).withMerger(merger).setTo(element);
    }

    private Element getRequiredElement(Element element, String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return element;
        }
        return Pattern.compile("/").splitAsStream(path).reduce(element, this::getParentOrChildElement, (prev, next) -> next);
    }

    private static boolean fitsInScope(Property property, String scope) {
        PropertyRendering propertyRendering = property.getAnnotation(PropertyRendering.class);
        if (propertyRendering == null) {
            return true;
        }
        return Arrays.asList(propertyRendering.scope()).contains(scope);
    }

    public Element appendNonemptyChildElement(Element parent, Element child) {
        if (parent == null || XmlContextHelper.isBlankElement(child)) {
            return null;
        }
        return this.appendNonemptyChildElement(parent, child, DEFAULT_ATTRIBUTE_MERGER);
    }

    public Element appendNonemptyChildElement(Element parent, Element child, BinaryOperator<String> attributeMerger) {
        if (parent == null || XmlContextHelper.isBlankElement(child)) {
            return null;
        }
        Element existingChild = this.getChildElement(parent, child.getNodeName());
        if (existingChild == null) {
            return (Element)parent.appendChild(child.cloneNode(true));
        }
        for (Node grandchild = child.getFirstChild(); grandchild != null; grandchild = grandchild.getNextSibling()) {
            this.appendNonemptyChildElement(existingChild, (Element)grandchild, attributeMerger);
        }
        return XmlContextHelper.mergeAttributes(existingChild, child, attributeMerger);
    }

    private static Element mergeAttributes(Element first, Element second, BinaryOperator<String> attributeMerger) {
        NamedNodeMap newAttributes = second.getAttributes();
        for (int i = 0; i < newAttributes.getLength(); ++i) {
            AttributeHelper.forXmlTarget().forNamedValue(newAttributes.item(i).getNodeName(), String.class).withMerger(attributeMerger).setValue(newAttributes.item(i).getNodeValue(), first);
        }
        return first;
    }

    private static String mergeStringAttributes(String first, String second) {
        if (!StringUtil.isCollection(first) || !StringUtil.isCollection(second)) {
            return (String)DEFAULT_ATTRIBUTE_MERGER.apply(first, second);
        }
        Set<String> result = StringUtil.parseSet(first);
        result.addAll(StringUtil.parseSet(second));
        return StringUtil.format(result, String.class);
    }

    public Element getOrAddChildElement(Element parent, String childName) {
        return this.getChildElement(parent, childName, parentElement -> (Element)parentElement.appendChild(this.createNodeElement(childName)));
    }

    public Element getChildElement(Element parent, String childName) {
        return this.getChildElement(parent, childName, p -> null);
    }

    public Element getChildElement(Element parent, String childName, UnaryOperator<Element> fallbackSupplier) {
        if (parent == null) {
            return (Element)fallbackSupplier.apply(null);
        }
        if (childName.contains("/")) {
            return Arrays.stream(StringUtils.split((String)childName, (String)"/")).reduce(parent, (p, c) -> this.getChildElement((Element)p, (String)c, fallbackSupplier), (c1, c2) -> c2);
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !child.getNodeName().equals(childName)) continue;
            return (Element)child;
        }
        return (Element)fallbackSupplier.apply(parent);
    }

    private Element getParentOrChildElement(Element element, String nodeName) {
        if (nodeName.contains("..")) {
            return (Element)element.getParentNode();
        }
        return this.getOrAddChildElement(element, nodeName);
    }

    private static boolean isBlankElement(Element element) {
        if (element == null) {
            return true;
        }
        if (element.hasChildNodes() || element.getAttributes().getLength() > 1) {
            return false;
        }
        return "jcr:primaryType".equals(element.getAttributes().item(0).getNodeName());
    }

    public void appendDataAttributes(Element element, Data[] data) {
        if (ArrayUtils.isEmpty((Object[])data)) {
            return;
        }
        this.appendDataAttributes(element, Arrays.stream(data).collect(Collectors.toMap(Data::name, Data::value)));
    }

    public void appendDataAttributes(Element element, Map<String, String> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        Element graniteDataNode = this.getOrAddChildElement(element, "granite:data");
        data.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey()))).forEach(entry -> graniteDataNode.setAttribute((String)entry.getKey(), (String)entry.getValue()));
    }
}

