/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.sources;

import com.exadel.aem.toolkit.api.annotations.main.Setting;
import com.exadel.aem.toolkit.plugin.metadata.scripting.DataStack;
import com.exadel.aem.toolkit.plugin.sources.SourceImpl;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

class ClassSourceImpl
extends SourceImpl {
    private final Class<?> value;

    ClassSourceImpl(Class<?> value) {
        super((AnnotatedElement)value);
        this.value = value;
    }

    public String getName() {
        return this.isValid() ? this.value.getName() : "";
    }

    public boolean isValid() {
        return this.value != null;
    }

    @Override
    public <T> T adaptTo(Class<T> type) {
        if (Class.class.equals(type)) {
            return type.cast(this.value);
        }
        return super.adaptTo(type);
    }

    @Override
    <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.value.getDeclaredAnnotation(type);
    }

    @Override
    DataStack getDataStack() {
        DataStack result = new DataStack();
        for (Class<?> ancestor : ClassUtil.getInheritanceTree(this.value, false)) {
            result.append((Setting[])ancestor.getAnnotationsByType(Setting.class));
        }
        result.append(this.adaptTo((Class<T>)Setting[].class));
        return result;
    }
}

