/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.sources;

import com.exadel.aem.toolkit.api.annotations.main.AemComponent;
import com.exadel.aem.toolkit.api.annotations.main.Dialog;
import com.exadel.aem.toolkit.api.annotations.main.WriteMode;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.sources.ClassSourceImpl;
import com.exadel.aem.toolkit.plugin.sources.ComponentSource;
import com.exadel.aem.toolkit.plugin.sources.Sources;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

class ComponentSourceImpl
extends ClassSourceImpl
implements ComponentSource {
    private static final String ROOT_DIRECTORY = "jcr_root";
    private final String componentPath = this.preparePath();
    private List<Source> extraViews;

    ComponentSourceImpl(Class<?> value) {
        super(value);
    }

    @Override
    public String getPath() {
        return this.componentPath;
    }

    @Override
    public WriteMode getWriteMode() {
        return this.tryAdaptTo(AemComponent.class).map(AemComponent::writeMode).orElse(null);
    }

    @Override
    public List<Source> getViews() {
        Class[] referencedViews = this.tryAdaptTo(AemComponent.class).map(AemComponent::views).orElse(ArrayUtils.EMPTY_CLASS_ARRAY);
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), Arrays.stream(referencedViews).map(Sources::fromClass)}).distinct().collect(Collectors.toList());
    }

    @Override
    public void merge(Source view) {
        if (!(view instanceof ClassSourceImpl) || view instanceof ComponentSourceImpl) {
            return;
        }
        if (this.extraViews == null) {
            this.extraViews = new ArrayList<Source>();
        }
        this.extraViews.add(view);
    }

    @Override
    public boolean matches(String path) {
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)ROOT_DIRECTORY)) {
            return StringUtils.equals((CharSequence)this.componentPath, (CharSequence)path);
        }
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            return StringUtils.equals((CharSequence)this.componentPath, (CharSequence)(ROOT_DIRECTORY + path));
        }
        return StringUtils.endsWith((CharSequence)this.componentPath, (CharSequence)path);
    }

    private String preparePath() {
        String pathByComponent = this.tryAdaptTo(AemComponent.class).map(AemComponent::path).orElse(null);
        String pathByDialog = this.tryAdaptTo(Dialog.class).map(Dialog::name).orElse(null);
        String effectivePath = Stream.of(pathByComponent, pathByDialog).filter(StringUtils::isNotBlank).findFirst().orElse(pathByDialog);
        if (StringUtils.isBlank((CharSequence)effectivePath)) {
            return null;
        }
        if (StringUtils.startsWith((CharSequence)effectivePath, (CharSequence)ROOT_DIRECTORY)) {
            return effectivePath;
        }
        if (effectivePath.startsWith("/jcr_root")) {
            return effectivePath.substring(1);
        }
        if (effectivePath.startsWith("/")) {
            return ROOT_DIRECTORY + effectivePath;
        }
        String result = StringUtils.stripEnd((String)PluginRuntime.context().getSettings().getPathBase(this.adaptTo((Class<T>)Class.class)), (String)"/") + "/" + effectivePath;
        return StringUtils.strip((String)result, (String)"/");
    }

    @Override
    public <T> T adaptTo(Class<T> type) {
        Object result = super.adaptTo(type);
        if (result != null || this.extraViews == null) {
            return result;
        }
        for (Source extraView : this.extraViews) {
            result = extraView.adaptTo(type);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

