/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.sources;

import com.exadel.aem.toolkit.api.annotations.main.Setting;
import com.exadel.aem.toolkit.api.annotations.meta.ResourceType;
import com.exadel.aem.toolkit.api.annotations.widgets.FieldSet;
import com.exadel.aem.toolkit.api.annotations.widgets.MultiField;
import com.exadel.aem.toolkit.api.handlers.EmbeddedMemberSource;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.markers._Default;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.scripting.DataStack;
import com.exadel.aem.toolkit.plugin.sources.ModifiableMemberSource;
import com.exadel.aem.toolkit.plugin.sources.SourceImpl;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import com.exadel.aem.toolkit.plugin.utils.MemberUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

class MemberSourceImpl
extends SourceImpl
implements ModifiableMemberSource {
    private final Class<?> componentType;
    private final Member member;
    private Class<?> declaringClass;
    private Class<?> reportingClass;
    private MemberSource upstreamSource;
    private String name;

    MemberSourceImpl(Member member) {
        super((AnnotatedElement)((Object)member));
        this.member = member;
        this.name = member.getName();
        this.declaringClass = member.getDeclaringClass();
        this.reportingClass = member.getDeclaringClass();
        this.componentType = MemberUtil.getComponentType(member);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public void setDeclaringClass(Class<?> value) {
        this.declaringClass = value;
    }

    public Class<?> getReportingClass() {
        return this.reportingClass;
    }

    @Override
    public void setReportingClass(Class<?> value) {
        this.reportingClass = value;
    }

    public MemberSource getUpstreamSource() {
        return this.upstreamSource;
    }

    @Override
    public void setUpstreamSource(MemberSource value) {
        this.upstreamSource = value;
    }

    public Class<?> getValueType() {
        Class result = this.componentType;
        if (this.adaptTo((Class<T>)MultiField.class) != null && this.adaptTo((Class<T>)MultiField.class).value() != _Default.class) {
            result = this.adaptTo((Class<T>)MultiField.class).value();
        } else if (this.adaptTo((Class<T>)MultiField.class) != null && this.adaptTo((Class<T>)MultiField.class).field() != _Default.class) {
            result = this.adaptTo((Class<T>)MultiField.class).field();
        } else if (this.adaptTo((Class<T>)FieldSet.class) != null && this.adaptTo((Class<T>)FieldSet.class).value() != _Default.class) {
            result = this.adaptTo((Class<T>)FieldSet.class).value();
        }
        return result;
    }

    public boolean isSame(Source other) {
        if (!(other instanceof MemberSource)) {
            return super.isSame(other);
        }
        return this.getDeclaringClass().equals(((MemberSource)other).getDeclaringClass()) && StringUtils.equals((CharSequence)this.getName(), (CharSequence)other.getName());
    }

    public boolean isValid() {
        return this.member != null && (!(this.member instanceof Field) || !this.member.getDeclaringClass().isInterface()) && !Modifier.isStatic(this.member.getModifiers()) && this.isWidgetAnnotationPresent();
    }

    @Override
    public <T> T adaptTo(Class<T> type) {
        boolean canCastToMethod;
        boolean canCastToField = this.member instanceof Field && (type.equals(Field.class) || type.equals(Member.class));
        boolean bl = canCastToMethod = this.member instanceof Method && (type.equals(Method.class) || type.equals(Member.class));
        if (canCastToField || canCastToMethod) {
            return type.cast(this.member);
        }
        return super.adaptTo(type);
    }

    @Override
    <T extends Annotation> T getAnnotation(Class<T> type) {
        return ((AnnotatedElement)((Object)this.member)).getDeclaredAnnotation(type);
    }

    @Override
    DataStack getDataStack() {
        DataStack result = new DataStack();
        LinkedList<MemberSource> upstreamSources = new LinkedList<MemberSource>();
        MemberSource currentUpstreamSource = this.upstreamSource;
        while (currentUpstreamSource instanceof EmbeddedMemberSource) {
            upstreamSources.add(currentUpstreamSource);
            currentUpstreamSource = ((EmbeddedMemberSource)currentUpstreamSource).getUpstreamSource();
        }
        upstreamSources.descendingIterator().forEachRemaining(upstream -> {
            for (Class<?> ancestor : ClassUtil.getInheritanceTree(upstream.getDeclaringClass())) {
                result.append((Setting[])ancestor.getAnnotationsByType(Setting.class));
            }
        });
        for (Class<?> ancestor : ClassUtil.getInheritanceTree(this.getDeclaringClass())) {
            result.append((Setting[])ancestor.getAnnotationsByType(Setting.class));
        }
        upstreamSources.descendingIterator().forEachRemaining(upstream -> result.append((Setting[])upstream.adaptTo(Setting[].class)));
        result.append(this.adaptTo((Class<T>)Setting[].class));
        return result;
    }

    private boolean isWidgetAnnotationPresent() {
        return Arrays.stream((Object[])this.adaptTo((Class<T>)Annotation[].class)).anyMatch(annotation -> {
            Metadata metadata = Metadata.from(annotation);
            ResourceType resourceType = metadata.getAnnotation(ResourceType.class);
            return resourceType != null && StringUtils.isNotBlank((CharSequence)resourceType.value());
        });
    }
}

