/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.sources;

import com.exadel.aem.toolkit.api.annotations.main.Setting;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.plugin.adapters.AdaptationBase;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.Property;
import com.exadel.aem.toolkit.plugin.metadata.scripting.DataStack;
import com.exadel.aem.toolkit.plugin.metadata.scripting.ScriptingHelper;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;

abstract class SourceImpl
extends AdaptationBase<Source>
implements Source {
    private final Map<Class<?>, Object> metadata;
    private boolean metadataProcessed = false;

    SourceImpl(AnnotatedElement annotated) {
        super(Source.class);
        this.metadata = SourceImpl.collectMetadata(annotated);
    }

    @Override
    public <T> T adaptTo(Class<T> type) {
        T result = Stream.of(() -> type == DataStack.class ? type.cast(this.getDataStack()) : null, () -> this.adaptToStoredAnnotation(type), () -> this.adaptToStoredAnnotationArray(type), () -> this.adaptToForeignAnnotation(type)).map(Supplier::get).filter(Objects::nonNull).findFirst().orElse(null);
        if (result != null) {
            return result;
        }
        return super.adaptTo(type);
    }

    private <T> T adaptToStoredAnnotation(Class<T> type) {
        if (!type.isAnnotation() || !this.getMetadata().containsKey(type)) {
            return null;
        }
        return type.cast(this.getMetadata().get(type));
    }

    private <T> T adaptToStoredAnnotationArray(Class<T> type) {
        if (!type.isArray()) {
            return null;
        }
        if (type.getComponentType().equals(Annotation.class)) {
            Annotation[] result = (Annotation[])this.getMetadata().values().stream().flatMap(value -> value.getClass().isArray() ? Arrays.stream((Annotation[])value) : Stream.of(value)).map(Annotation.class::cast).toArray(Annotation[]::new);
            return type.cast(result);
        }
        if (type.getComponentType().isAnnotation() && this.getMetadata().containsKey(type)) {
            Object stored = this.getMetadata().get(type);
            Object newArray = Array.newInstance(type.getComponentType(), Array.getLength(stored));
            for (int i = 0; i < Array.getLength(stored); ++i) {
                Array.set(newArray, i, Array.get(stored, i));
            }
            return type.cast(newArray);
        }
        if (type.getComponentType().isAnnotation() && this.getMetadata().containsKey(type.getComponentType())) {
            Object newArray = Array.newInstance(type.getComponentType(), 1);
            Array.set(newArray, 0, this.getMetadata().get(type.getComponentType()));
            return type.cast(newArray);
        }
        if (type.getComponentType().isAnnotation()) {
            return type.cast(Array.newInstance(type.getComponentType(), 0));
        }
        return null;
    }

    private <T> T adaptToForeignAnnotation(Class<T> type) {
        return ClassUtils.isAssignable(type, Annotation.class) ? (T)this.getAnnotation(type) : null;
    }

    abstract <T extends Annotation> T getAnnotation(Class<T> var1);

    abstract DataStack getDataStack();

    private Map<Class<?>, Object> getMetadata() {
        if (!this.metadataProcessed) {
            this.metadataProcessed = true;
            SourceImpl.applyInterpolation(this, this.metadata);
        }
        return this.metadata;
    }

    private static Map<Class<?>, Object> collectMetadata(AnnotatedElement value) {
        LinkedHashMap result = new LinkedHashMap();
        for (Annotation annotation : value.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getPackage().getName().startsWith("com.exadel.aem.toolkit") && !PluginRuntime.context().getReflection().isHandled(annotation)) continue;
            Metadata entry = Metadata.from(annotation);
            result.put(annotation.annotationType(), entry);
            if (!SourceImpl.isRepeatableContainer(entry)) continue;
            Property repeatableValues = entry.getProperty("value");
            Metadata[] metadataEntries = (Metadata[])Arrays.stream((Annotation[])repeatableValues.getValue()).map(Metadata::from).toArray(Metadata[]::new);
            result.put(repeatableValues.getType(), metadataEntries);
        }
        return result;
    }

    private static boolean isRepeatableContainer(Metadata value) {
        if (value == null) {
            return false;
        }
        Property valueProperty = value.hasProperty("value") ? value.getProperty("value") : null;
        return valueProperty != null && valueProperty.getValue() != null && valueProperty.getType().isArray() && valueProperty.getComponentType().isAnnotation() && valueProperty.getComponentType().isAnnotationPresent(Repeatable.class);
    }

    private static void applyInterpolation(Source source, Map<Class<?>, Object> metadata) {
        for (Object value : metadata.values()) {
            if (value instanceof Metadata[] && !value.getClass().getComponentType().equals(Setting.class)) {
                for (Metadata metadataEntry : (Metadata[])value) {
                    ScriptingHelper.interpolate(metadataEntry, source);
                }
                continue;
            }
            if (!(value instanceof Metadata)) continue;
            ScriptingHelper.interpolate((Metadata)value, source);
        }
    }
}

