/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.targets;

import com.exadel.aem.toolkit.api.annotations.meta.PropertyRendering;
import com.exadel.aem.toolkit.api.annotations.meta.StringTransformation;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.api.markers._Default;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.Property;
import com.exadel.aem.toolkit.plugin.targets.TargetImpl;
import com.exadel.aem.toolkit.plugin.utils.StringUtil;
import com.exadel.aem.toolkit.plugin.validators.Validation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class AttributeHelper<T, V> {
    private final Class<T> holderType;
    private final Class<V> valueType;
    private boolean valueTypeIsSupported;
    private Annotation annotation;
    private String annotationPropertyName;
    private String attributeName;
    private String[] ignoredValues;
    private boolean blankValuesAllowed;
    private Class<?> typeHintValueType;
    private boolean isEnum;
    private StringTransformation transformation;
    private Validation validationChecker = Validation.defaultChecker();
    private BinaryOperator<String> valueMerger = TargetImpl.DEFAULT_ATTRIBUTE_MERGER;

    private AttributeHelper(Class<T> holderType, Class<V> valueType) {
        this.holderType = holderType;
        this.valueType = valueType;
    }

    public AttributeHelper<T, V> withName(String value) {
        this.attributeName = value;
        return this;
    }

    public AttributeHelper<T, V> withMerger(BinaryOperator<String> value) {
        this.valueMerger = value;
        return this;
    }

    public void setTo(T target) {
        if (!this.valueTypeIsSupported) {
            return;
        }
        Object invocationResult = Metadata.from(this.annotation).getValue(this.annotationPropertyName);
        if (invocationResult == null) {
            return;
        }
        if (invocationResult.getClass().isArray()) {
            List invocationResultList = Arrays.stream(AttributeHelper.castToArray(invocationResult)).map(this::cast).filter(Objects::nonNull).collect(Collectors.toList());
            this.setValue(invocationResultList, target);
        } else {
            this.setValue(this.cast(invocationResult), target);
        }
    }

    public void setValue(V value, T target) {
        String valueString;
        if (!this.valueTypeIsSupported) {
            return;
        }
        String string = valueString = value != null ? value.toString() : "";
        if (!this.isValid(valueString)) {
            this.removeAttributeFrom(target);
            return;
        }
        this.setValue(StringUtil.format(value, this.getTypeHintValueType()), target);
    }

    public void setValue(List<V> value, T target) {
        if (!this.valueTypeIsSupported || value == null || value.isEmpty()) {
            return;
        }
        List validValues = value.stream().filter(Objects::nonNull).filter(obj -> this.isValid(obj.toString())).collect(Collectors.toList());
        if (validValues.isEmpty()) {
            return;
        }
        this.setValue(StringUtil.format(validValues, this.getTypeHintValueType()), target);
    }

    private void setValue(String value, T target) {
        if (Element.class.equals(this.holderType)) {
            Element element = (Element)target;
            String oldAttributeValue = element.hasAttribute(this.attributeName) ? element.getAttribute(this.attributeName) : "";
            element.setAttribute(this.attributeName, (String)this.valueMerger.apply(oldAttributeValue, value));
        } else if (Target.class.equals(this.holderType)) {
            Target castedTarget = (Target)target;
            String oldAttributeValue = castedTarget.getAttributes().getOrDefault(this.attributeName, "");
            castedTarget.attribute(this.attributeName, (String)this.valueMerger.apply(oldAttributeValue, value));
        }
    }

    private void removeAttributeFrom(T target) {
        if (Element.class.equals(this.holderType)) {
            ((Element)target).removeAttribute(this.attributeName);
        } else if (Target.class.equals(this.holderType)) {
            ((Target)target).getAttributes().remove(this.attributeName);
        }
    }

    private boolean isValid(String value) {
        if (StringUtils.isBlank((CharSequence)value) && !this.blankValuesAllowed) {
            return false;
        }
        return !ArrayUtils.contains((Object[])this.ignoredValues, (Object)value);
    }

    private Class<?> getTypeHintValueType() {
        return this.typeHintValueType != null ? this.typeHintValueType : this.valueType;
    }

    private V cast(Object value) {
        if (!this.validationChecker.test(value) || value == null) {
            return null;
        }
        if (this.isEnum) {
            return this.valueType.cast(AttributeHelper.transform(this.transformation, value.toString()));
        }
        if (this.valueType.equals(String.class)) {
            String result = AttributeHelper.transform(this.transformation, this.valueType.cast(value).toString());
            return this.valueType.cast(result);
        }
        return this.valueType.cast(value);
    }

    private static Object[] castToArray(Object value) {
        Object[] result = new Object[Array.getLength(value)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Array.get(value, i);
        }
        return result;
    }

    private static String transform(StringTransformation transformation, String value) {
        if (transformation == null) {
            return value;
        }
        return transformation.apply(value);
    }

    public static Builder<Element> forXmlTarget() {
        return new Builder<Element>(Element.class);
    }

    public static AttributeHelper<Target, Object> forAnnotationProperty(Annotation annotation, Property property) {
        return new Builder(Target.class).forAnnotationProperty(annotation, property);
    }

    static /* synthetic */ String[] access$702(AttributeHelper x0, String[] x1) {
        x0.ignoredValues = x1;
        return x1;
    }

    public static class Builder<T> {
        private final Class<T> holderType;

        private Builder(Class<T> holderType) {
            this.holderType = holderType;
        }

        public AttributeHelper<T, Object> forAnnotationProperty(Annotation annotation, Property property) {
            AttributeHelper attributeSetter = new AttributeHelper(this.holderType, Builder.getWrappedValueType(property));
            if (!Builder.fits(property)) {
                return attributeSetter;
            }
            attributeSetter.valueTypeIsSupported = true;
            attributeSetter.annotationPropertyName = property.getName();
            attributeSetter.annotation = annotation;
            attributeSetter.attributeName = property.getName();
            attributeSetter.isEnum = property.getType().isEnum() || property.getType().getComponentType() != null && property.getType().getComponentType().isEnum();
            if (property.getAnnotation(PropertyRendering.class) != null) {
                PropertyRendering propertyRendering = property.getAnnotation(PropertyRendering.class);
                AttributeHelper.access$702(attributeSetter, propertyRendering.ignoreValues());
                attributeSetter.blankValuesAllowed = propertyRendering.allowBlank();
                attributeSetter.transformation = propertyRendering.transform();
                if (!propertyRendering.valueType().equals(_Default.class)) {
                    attributeSetter.typeHintValueType = propertyRendering.valueType();
                }
            }
            if (!property.valueIsDefault()) {
                attributeSetter.validationChecker = Validation.forProperty(property);
            }
            return attributeSetter;
        }

        public <V> AttributeHelper<T, V> forNamedValue(String name, Class<V> valueType) {
            AttributeHelper attributeSetter = new AttributeHelper(this.holderType, valueType);
            if (!Builder.fits(valueType)) {
                return attributeSetter;
            }
            attributeSetter.valueTypeIsSupported = true;
            attributeSetter.attributeName = name;
            return attributeSetter;
        }

        private static boolean fits(Property property) {
            return Builder.fits(Builder.getWrappedValueType(property));
        }

        private static boolean fits(Class<?> valueType) {
            return valueType.equals(String.class) || valueType.equals(Long.class) || valueType.equals(Double.class) || valueType.equals(Boolean.class);
        }

        private static Class<?> getWrappedValueType(Property property) {
            Class<?> effectiveType = property.getComponentType();
            if (effectiveType.isEnum()) {
                return String.class;
            }
            return ClassUtils.primitiveToWrapper(effectiveType);
        }
    }
}

