/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.targets;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

class PathSplitHelper {
    private final String path;
    private List<Pair<Integer, Integer>> escapedSequences;

    private PathSplitHelper(String path) {
        this.path = path;
        if (path == null || !path.contains("/") || !path.contains("\"")) {
            return;
        }
        this.escapedSequences = PathSplitHelper.getEscapedSequences(path);
    }

    boolean isSplittable() {
        if (this.escapedSequences == null || this.escapedSequences.isEmpty()) {
            return StringUtils.contains((CharSequence)this.path, (CharSequence)"/");
        }
        int cursor = this.path.indexOf("/");
        while (cursor >= 0) {
            int position = cursor;
            if (this.escapedSequences.stream().noneMatch(pair -> position > (Integer)pair.getLeft() && position < (Integer)pair.getRight())) {
                return true;
            }
            cursor = this.path.indexOf("/", cursor + 1);
        }
        return false;
    }

    Queue<String> getChunks() {
        if (this.path == null) {
            return new LinkedList<String>();
        }
        if (this.escapedSequences == null || this.escapedSequences.isEmpty()) {
            return Pattern.compile("/").splitAsStream(this.path).collect(Collectors.toCollection(LinkedList::new));
        }
        LinkedList<String> result = new LinkedList<String>();
        ArrayList<Integer> splitPositions = new ArrayList<Integer>();
        int cursor = this.path.indexOf("/");
        while (cursor >= 0) {
            int position = cursor;
            if (this.escapedSequences.stream().noneMatch(pair -> position > (Integer)pair.getLeft() && position < (Integer)pair.getRight())) {
                splitPositions.add(cursor);
            }
            cursor = this.path.indexOf("/", cursor + 1);
        }
        if (splitPositions.isEmpty()) {
            result.add(this.path);
            return result;
        }
        for (int i = 0; i < splitPositions.size(); ++i) {
            if (i == 0) {
                result.add(this.path.substring(0, (Integer)splitPositions.get(i)));
            } else {
                result.add(this.path.substring((Integer)splitPositions.get(i - 1) + 1, (Integer)splitPositions.get(i)));
            }
            if (i != splitPositions.size() - 1) continue;
            result.add(this.path.substring((Integer)splitPositions.get(i) + 1));
        }
        return result;
    }

    private static List<Pair<Integer, Integer>> getEscapedSequences(String path) {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        int opening = path.indexOf("\"");
        while (opening >= 0) {
            int closing = path.indexOf("\"", opening + 1);
            if (closing < 0) {
                return result;
            }
            result.add((Pair<Integer, Integer>)Pair.of((Object)opening, (Object)closing));
            opening = path.indexOf("\"", closing + 1);
        }
        return result;
    }

    static PathSplitHelper of(String path) {
        return new PathSplitHelper(path);
    }
}

