/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.targets;

import com.exadel.aem.toolkit.api.annotations.meta.AnnotationRendering;
import com.exadel.aem.toolkit.api.annotations.meta.PropertyMapping;
import com.exadel.aem.toolkit.api.annotations.meta.PropertyRendering;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.adapters.AdaptationBase;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.Property;
import com.exadel.aem.toolkit.plugin.targets.AttributeHelper;
import com.exadel.aem.toolkit.plugin.targets.LegacyHandlerAcceptor;
import com.exadel.aem.toolkit.plugin.targets.PathSplitHelper;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import com.exadel.aem.toolkit.plugin.utils.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

class TargetImpl
extends AdaptationBase<Target>
implements Target,
LegacyHandlerAcceptor {
    static final BinaryOperator<String> DEFAULT_ATTRIBUTE_MERGER = (first, second) -> {
        if (StringUtils.isNotBlank((CharSequence)first) && StringUtils.isBlank((CharSequence)second)) {
            return first;
        }
        return StringUtils.isNotEmpty((CharSequence)second) ? second : first;
    };
    private final Map<String, String> attributes;
    private final List<Target> children;
    private String name;
    private Target parent;
    private String prefix;
    private String postfix;
    private String scope;

    TargetImpl(String name, Target parent) {
        super(Target.class);
        this.name = name;
        this.parent = parent;
        this.attributes = new HashMap<String, String>();
        this.children = new LinkedList<Target>();
        this.scope = parent != null ? parent.getScope() : ".content.xml";
        this.attributes.put("jcr:primaryType", "nt:unstructured");
    }

    public String getName() {
        return this.name;
    }

    public String getNamePrefix() {
        if (this.getParent() == null) {
            return StringUtils.defaultString((String)this.prefix);
        }
        return this.getParent().getNamePrefix() + StringUtils.defaultString((String)this.prefix);
    }

    public Target namePrefix(String value) {
        this.prefix = NamingUtil.getValidFieldPrefix(value);
        return this;
    }

    public String getNamePostfix() {
        if (this.getParent() == null) {
            return StringUtils.defaultString((String)this.postfix);
        }
        return StringUtils.defaultString((String)this.postfix) + this.getParent().getNamePostfix();
    }

    public Target namePostfix(String value) {
        this.postfix = NamingUtil.getValidFieldPostfix(value);
        return this;
    }

    public Target getParent() {
        return this.parent;
    }

    public List<Target> getChildren() {
        return this.children;
    }

    public boolean isEmpty() {
        if (!this.children.isEmpty() || this.attributes.size() > 1) {
            return false;
        }
        return this.attributes.isEmpty() || this.attributes.getOrDefault("jcr:primaryType", "nt:unstructured").equals("nt:unstructured");
    }

    public String getScope() {
        return this.scope;
    }

    void setScope(String value) {
        this.scope = value;
    }

    public Target getTarget(String path) {
        return this.getTargetInternal(path, false);
    }

    public Target getOrCreateTarget(String path) {
        return this.getTargetInternal(path, true);
    }

    public Target createTarget(String path) {
        String effectivePath;
        if (path == null) {
            return null;
        }
        boolean isEscaped = path.startsWith("\"") && path.endsWith("\"");
        String string = effectivePath = isEscaped ? StringUtils.strip((String)path, (String)"\"") : path;
        if (!isEscaped && PathSplitHelper.of(effectivePath).isSplittable()) {
            Target existingTarget = this.getTarget(effectivePath);
            if (existingTarget != null && !this.equals(existingTarget)) {
                this.removeTarget(effectivePath);
            } else if (this.equals(existingTarget)) {
                return this;
            }
            return this.getOrCreateTarget(effectivePath);
        }
        if ("..".equals(effectivePath)) {
            return this.getParent() != null ? this.getParent() : null;
        }
        if (".".equals(effectivePath)) {
            return this;
        }
        String effectiveName = NamingUtil.getUniqueName(effectivePath, "item", this);
        TargetImpl child = new TargetImpl(effectiveName, this);
        this.children.add(child);
        return child;
    }

    private Target getTargetInternal(String path, boolean createIfMissing) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        boolean isEscaped = path.startsWith("\"") && path.endsWith("\"");
        String effectivePath = StringUtils.strip((String)path, (String)"\"");
        PathSplitHelper pathSplitHelper = PathSplitHelper.of(effectivePath);
        if (!isEscaped && pathSplitHelper.isSplittable()) {
            String currentChunk;
            Queue<String> pathChunks = pathSplitHelper.getChunks();
            TargetImpl current = this;
            while (!pathChunks.isEmpty() && (current = current.getTargetInternal(currentChunk = pathChunks.poll(), createIfMissing)) != null) {
            }
            return current;
        }
        if ("..".equals(effectivePath) && this.getParent() != null) {
            return this.getParent();
        }
        if ("..".equals(effectivePath) || ".".equals(effectivePath)) {
            return this;
        }
        String nameToFind = NamingUtil.getValidNodeName(effectivePath);
        Target result = this.getChildren().stream().filter(child -> nameToFind.equals(child.getName())).findFirst().orElse(null);
        if (result == null && createIfMissing) {
            result = this.createTarget(path);
        }
        return result;
    }

    public void addTarget(Target other, int position) {
        if (other == null || other.findChild(child -> child.equals(this)) != null) {
            return;
        }
        if (other.getParent() != null) {
            other.getParent().getChildren().remove(other);
        }
        if (other instanceof TargetImpl) {
            ((TargetImpl)other).parent = this;
        }
        if (position > -1 && position < this.getChildren().size()) {
            this.getChildren().add(position, other);
        } else {
            this.getChildren().add(other);
        }
    }

    public void removeTarget(String path) {
        Target removable = this.getTarget(path);
        if (removable != null && removable.getParent() != null) {
            removable.getParent().getChildren().remove(removable);
        }
    }

    public Target findParent(Predicate<Target> filter) {
        if (filter == null) {
            return null;
        }
        for (Target current = this.getParent(); current != null; current = current.getParent()) {
            if (!filter.test(current)) continue;
            return current;
        }
        return null;
    }

    public Target findChild(Predicate<Target> filter) {
        if (filter == null) {
            return null;
        }
        return TargetImpl.findChild(this, filter);
    }

    private static Target findChild(Target current, Predicate<Target> filter) {
        Target match = current.getChildren().stream().filter(filter).findFirst().orElse(null);
        if (match != null) {
            return match;
        }
        for (Target child : current.getChildren()) {
            match = TargetImpl.findChild(child, filter);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public List<Target> findChildren(Predicate<Target> filter) {
        if (filter == null) {
            return Collections.emptyList();
        }
        ArrayList<Target> result = new ArrayList<Target>();
        TargetImpl.findChildren(this, filter, result);
        return result;
    }

    private static void findChildren(Target current, Predicate<Target> filter, List<Target> collection) {
        List matches = current.getChildren().stream().filter(filter).collect(Collectors.toList());
        collection.addAll(matches);
        for (Target child : current.getChildren()) {
            TargetImpl.findChildren(child, filter, collection);
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Target attribute(String name, String value) {
        if (value != null) {
            this.attributes.put(name, value);
        }
        return this;
    }

    public Target attribute(String name, String[] value) {
        if (value != null) {
            this.attributes.put(name, StringUtil.format(value, String.class));
        }
        return this;
    }

    public Target attribute(String name, boolean value) {
        this.attributes.put(name, StringUtil.format(value, Boolean.class));
        return this;
    }

    public Target attribute(String name, boolean[] value) {
        if (value != null) {
            List booleanValues = IntStream.range(0, value.length).mapToObj(pos -> value[pos]).collect(Collectors.toList());
            this.attributes.put(name, StringUtil.format(booleanValues, Boolean.class));
        }
        return this;
    }

    public Target attribute(String name, long value) {
        this.attributes.put(name, StringUtil.format(value, Long.class));
        return this;
    }

    public Target attribute(String name, long[] value) {
        if (value != null) {
            this.attributes.put(name, StringUtil.format(LongStream.of(value).boxed().collect(Collectors.toList()), Long.class));
        }
        return this;
    }

    public Target attribute(String name, double value) {
        this.attributes.put(name, StringUtil.format(value, Double.class));
        return this;
    }

    public Target attribute(String name, double[] value) {
        if (value != null) {
            this.attributes.put(name, StringUtil.format(DoubleStream.of(value).boxed().collect(Collectors.toList()), Double.class));
        }
        return this;
    }

    public Target attribute(String name, Date value) {
        if (value != null) {
            this.attributes.put(name, StringUtil.format(value, Date.class));
        }
        return this;
    }

    public Target attribute(String name, Date[] value) {
        if (value != null) {
            this.attributes.put(name, StringUtil.format(value, Date.class));
        }
        return this;
    }

    public Target attribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, StringUtil.format(value, String.class));
        }
        return this;
    }

    public Target attribute(String name, Object[] value) {
        if (value != null) {
            this.attributes.put(name, StringUtil.format(value, String.class));
        }
        return this;
    }

    public Target attributes(Annotation value, Predicate<Method> filter) {
        if (value == null) {
            return this;
        }
        this.populateAnnotationProperties(value, filter == null ? method -> true : filter);
        return this;
    }

    @Override
    public Target attributes(Element value) {
        if (value != null) {
            this.populateElementProperties(value);
        }
        return this;
    }

    private void populateElementProperties(Element value) {
        this.name = value.getTagName();
        IntStream.range(0, value.getAttributes().getLength()).mapToObj(pos -> value.getAttributes().item(pos)).forEach(nodeAttr -> this.attributes.put(nodeAttr.getNodeName(), nodeAttr.getNodeValue()));
        IntStream.range(0, value.getChildNodes().getLength()).mapToObj(pos -> value.getChildNodes().item(pos)).forEach(childNode -> {
            TargetImpl newChild = (TargetImpl)this.getOrCreateTarget(childNode.getNodeName());
            newChild.attributes((Element)childNode);
        });
    }

    private void populateAnnotationProperties(Annotation annotation, Predicate<Method> filter) {
        String propertyPrefix = TargetImpl.getPropertyPrefix(annotation);
        String nodePrefix = propertyPrefix.contains("/") ? StringUtils.substringBeforeLast((String)propertyPrefix, (String)"/") : "";
        TargetImpl effectiveTarget = StringUtils.isNotEmpty((CharSequence)nodePrefix) ? this.getOrCreateTarget(nodePrefix) : this;
        Metadata.from(annotation).stream().filter(prop -> prop.matches(filter)).forEach(method -> TargetImpl.populateAnnotationProperty(annotation, method, effectiveTarget));
    }

    private static void populateAnnotationProperty(Annotation annotation, Property property, Target target) {
        String prefixByPropertyMapping;
        String namePrefix;
        boolean ignorePrefix = false;
        String propertyName = property.getName();
        PropertyRendering propertyRendering = property.getAnnotation(PropertyRendering.class);
        if (propertyRendering != null) {
            propertyName = NamingUtil.getValidFieldName((String)StringUtils.defaultIfBlank((CharSequence)propertyRendering.name(), (CharSequence)propertyName));
            ignorePrefix = propertyRendering.ignorePrefix();
        }
        String string = namePrefix = (prefixByPropertyMapping = TargetImpl.getPropertyPrefix(annotation)).contains("/") ? StringUtils.substringAfterLast((String)prefixByPropertyMapping, (String)"/") : prefixByPropertyMapping;
        if (!ignorePrefix && StringUtils.isNotBlank((CharSequence)prefixByPropertyMapping)) {
            propertyName = propertyName.contains("/") ? StringUtils.substringBeforeLast((String)propertyName, (String)"/") + "/" + namePrefix + StringUtils.substringAfterLast((String)propertyName, (String)"/") : namePrefix + propertyName;
        }
        Target effectiveTarget = target;
        if (propertyName.contains("/")) {
            effectiveTarget = target.getOrCreateTarget(StringUtils.substringBeforeLast((String)propertyName, (String)"/"));
            propertyName = StringUtils.substringAfterLast((String)propertyName, (String)"/");
        }
        BinaryOperator merger = TargetImpl::mergeStringAttributes;
        AttributeHelper.forAnnotationProperty(annotation, property).withName(propertyName).withMerger(merger).setTo(effectiveTarget);
    }

    private static String getPropertyPrefix(Annotation annotation) {
        Metadata metadata = Metadata.from(annotation);
        return Optional.ofNullable(metadata.getAnyAnnotation(AnnotationRendering.class, PropertyMapping.class)).map(a -> Metadata.from(a).getValue("prefix")).map(Object::toString).orElse("");
    }

    private static String mergeStringAttributes(String first, String second) {
        if (!StringUtil.isCollection(first) || !StringUtil.isCollection(second)) {
            return (String)DEFAULT_ATTRIBUTE_MERGER.apply(first, second);
        }
        Set<String> result = StringUtil.parseSet(first);
        result.addAll(StringUtil.parseSet(second));
        return StringUtil.format(result, String.class);
    }
}

