/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils;

import com.exadel.aem.toolkit.api.annotations.main.ClassField;
import com.exadel.aem.toolkit.api.annotations.main.ClassMember;
import com.exadel.aem.toolkit.api.annotations.widgets.accessory.Ignore;
import com.exadel.aem.toolkit.api.annotations.widgets.accessory.IgnoreFields;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.plugin.adapters.ClassMemberSetting;
import com.exadel.aem.toolkit.plugin.sources.Sources;
import com.exadel.aem.toolkit.plugin.utils.ReplacementHelper;
import com.exadel.aem.toolkit.plugin.utils.ordering.OrderingUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ClassUtil {
    private static final String WILDCARD = ".*";

    private ClassUtil() {
    }

    public static boolean matchesReference(Class<?> sourceClass, String ... references) {
        if (ArrayUtils.isEmpty((Object[])references)) {
            return true;
        }
        return Arrays.stream(references).filter(StringUtils::isNotBlank).map(ref -> ref.endsWith(WILDCARD) ? ref.substring(0, ref.length() - WILDCARD.length()) : ref).anyMatch(ref -> sourceClass.getName().startsWith(ref + "."));
    }

    public static List<Source> getSources(Class<?> sourceClass) {
        return ClassUtil.getSources(sourceClass, null, null, true);
    }

    public static List<Source> getSources(Class<?> sourceClass, MemberSource upstreamSource, Predicate<Source> condition, boolean ordered) {
        ArrayList raw = new ArrayList();
        ArrayList ignoredClassMembers = new ArrayList();
        for (Class<?> classEntry : ClassUtil.getInheritanceTree(sourceClass)) {
            Stream<Method> classMembersStream = sourceClass.isInterface() ? Arrays.stream(classEntry.getMethods()) : Stream.concat(Arrays.stream(classEntry.getDeclaredFields()), Arrays.stream(classEntry.getDeclaredMethods()));
            List classMemberSources = classMembersStream.map(member -> Sources.fromMember(member, sourceClass, upstreamSource)).filter(source -> source.isValid() && (condition == null || condition.test((Source)source))).collect(Collectors.toList());
            raw.addAll(classMemberSources);
            if (classEntry.getAnnotation(Ignore.class) != null && classEntry.getAnnotation(Ignore.class).members().length > 0) {
                Arrays.stream(classEntry.getAnnotation(Ignore.class).members()).map(classMember -> new ClassMemberSetting((ClassMember)classMember).populateDefaults(sourceClass, classEntry.getName())).forEach(ignoredClassMembers::add);
                continue;
            }
            if (classEntry.getAnnotation(IgnoreFields.class) == null) continue;
            Arrays.stream(classEntry.getAnnotation(IgnoreFields.class).value()).map(classMember -> new ClassMemberSetting((ClassField)classMember).populateDefaults(sourceClass)).forEach(ignoredClassMembers::add);
        }
        List<Source> reducedWithReplacements = raw.stream().filter(source -> ignoredClassMembers.stream().noneMatch(ignored -> ignored.matches((Source)source))).collect(ReplacementHelper.processSourceReplace());
        return ordered ? OrderingUtil.sortMembers(reducedWithReplacements) : reducedWithReplacements;
    }

    public static List<Class<?>> getInheritanceTree(Class<?> sourceClass) {
        return ClassUtil.getInheritanceTree(sourceClass, true);
    }

    public static List<Class<?>> getInheritanceTree(Class<?> sourceClass, boolean includeCurrent) {
        LinkedList result = new LinkedList();
        for (Class<?> current = sourceClass; current != null && !current.equals(Object.class); current = current.getSuperclass()) {
            if (current.equals(sourceClass) && !includeCurrent) continue;
            result.add(current);
            result.addAll(Arrays.asList(current.getInterfaces()));
        }
        Collections.reverse(result);
        return result;
    }

    public static Map<String, Object> getConstantValues(Class<?> sourceClass) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Field field : sourceClass.getDeclaredFields()) {
            Object fieldValue;
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                fieldValue = field.get(sourceClass);
            }
            catch (IllegalAccessException e) {
                fieldValue = null;
            }
            if (fieldValue == null) continue;
            result.put(field.getName(), fieldValue);
        }
        return result;
    }
}

