/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils;

import java.lang.reflect.Field;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

public class MemberUtil {
    private MemberUtil() {
    }

    public static Class<?> getComponentType(Member member) {
        Class<?> result;
        if (!(member instanceof Field) && !(member instanceof Method)) {
            return null;
        }
        Class<?> clazz = result = member instanceof Field ? ((Field)member).getType() : ((Method)member).getReturnType();
        if (result.isArray()) {
            result = result.getComponentType();
        }
        if (ClassUtils.isAssignable(result, Collection.class)) {
            return MemberUtil.getGenericType(member, result);
        }
        return result;
    }

    private static Class<?> getGenericType(Member member, Class<?> defaultValue) {
        try {
            Type genericType;
            Type type = genericType = member instanceof Field ? ((Field)member).getGenericType() : ((Method)member).getGenericReturnType();
            if (!(genericType instanceof ParameterizedType)) {
                return defaultValue;
            }
            Object[] typeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
            if (ArrayUtils.isEmpty((Object[])typeArguments)) {
                return defaultValue;
            }
            return typeArguments[0] instanceof Class ? (Class)typeArguments[0] : defaultValue;
        }
        catch (ClassCastException | TypeNotPresentException | MalformedParameterizedTypeException e) {
            return defaultValue;
        }
    }
}

