/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils;

import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.utils.XmlFactory;
import com.google.common.base.CaseFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

class NamingHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern NODE_NAME_INDEX_PATTERN = Pattern.compile("\\d*$");
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("^\\w+:");
    private static final Pattern INVALID_FIELD_NAME_PATTERN = Pattern.compile("^\\W+|[^\\w-/]$|[^\\w-/:]+");
    private static final Pattern INVALID_FIELD_NAME_POSTFIX_PATTERN = Pattern.compile("^[^\\w-/]+|[^\\w-/]$|[^\\w-/:]+");
    private static final Pattern INVALID_NODE_NAME_NS_PATTERN = Pattern.compile("^\\W*:|\\W+:$|[^\\w:]+");
    private static final Pattern INVALID_PLAIN_NAME_PATTERN = Pattern.compile("\\W+");
    private static final Pattern PARENT_PATH_PREFIX_PATTERN = Pattern.compile("^(?:\\.\\./)+");
    private boolean lowercaseFirst;
    private boolean preserveParentPath;
    private boolean allowSoloParentPath;
    private boolean removeInvalidNamespace;
    private Pattern clearingPattern;

    private NamingHelper() {
    }

    String getValidName(String source, String defaultValue) {
        boolean canDoWithoutDefaultValue;
        if (StringUtils.isBlank((CharSequence)source)) {
            return (String)StringUtils.defaultIfBlank((CharSequence)defaultValue, (CharSequence)"item");
        }
        String result = source.trim();
        Matcher parentPathPrefixMatcher = this.preserveParentPath ? PARENT_PATH_PREFIX_PATTERN.matcher(result) : null;
        String parentPathPrefix = parentPathPrefixMatcher != null && parentPathPrefixMatcher.find() ? parentPathPrefixMatcher.group() : "";
        Matcher whitespacePatternMatcher = WHITESPACE_PATTERN.matcher(result);
        boolean convertToCamelCase = whitespacePatternMatcher.find();
        if (convertToCamelCase) {
            result = WHITESPACE_PATTERN.matcher(result).replaceAll("_");
        }
        result = this.clearingPattern.matcher(result).replaceAll("");
        if (convertToCamelCase) {
            result = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, result);
        }
        boolean needsDefaultValue = result.isEmpty() || !Character.isAlphabetic(result.codePointAt(0));
        boolean bl = canDoWithoutDefaultValue = this.allowSoloParentPath && !parentPathPrefix.isEmpty();
        if (needsDefaultValue && !canDoWithoutDefaultValue) {
            result = StringUtils.defaultString((String)defaultValue) + result;
        }
        if (this.removeInvalidNamespace) {
            result = NamingHelper.removeInvalidNamespaces(result);
        }
        if (this.lowercaseFirst && !result.chars().allMatch(Character::isUpperCase)) {
            result = StringUtils.uncapitalize((String)result);
        }
        if (StringUtils.isNotEmpty((CharSequence)parentPathPrefix)) {
            return parentPathPrefix + result;
        }
        return result;
    }

    String getUniqueName(String source, String defaultValue, Target context) {
        String result = this.getValidName(source, defaultValue);
        if (context == null) {
            return result;
        }
        int index = 1;
        while (context.exists(result)) {
            result = NODE_NAME_INDEX_PATTERN.matcher(result).replaceFirst(String.valueOf(index++));
        }
        return result;
    }

    String getUniqueName(String source, String defaultValue, Element context) {
        String result = this.getValidName(source, defaultValue);
        if (context == null) {
            return result;
        }
        int index = 1;
        while (PluginRuntime.context().getXmlUtility().getChildElement(context, result) != null) {
            result = NODE_NAME_INDEX_PATTERN.matcher(result).replaceFirst(String.valueOf(index++));
        }
        return result;
    }

    private static String removeInvalidNamespaces(String value) {
        String namespaceCapture;
        Matcher namespaceMatcher = NAMESPACE_PATTERN.matcher(value);
        String string = namespaceCapture = namespaceMatcher.find() ? namespaceMatcher.group().substring(0, namespaceMatcher.end() - 1) : null;
        if (namespaceCapture != null && !XmlFactory.XML_NAMESPACES.containsKey(namespaceCapture)) {
            return value.replace(namespaceMatcher.group(), namespaceCapture);
        }
        return value;
    }

    static NamingHelper forFieldName() {
        NamingHelper helper = new NamingHelper();
        helper.preserveParentPath = true;
        helper.clearingPattern = INVALID_FIELD_NAME_PATTERN;
        return helper;
    }

    static NamingHelper forFieldNamePrefix() {
        NamingHelper helper = new NamingHelper();
        helper.preserveParentPath = true;
        helper.allowSoloParentPath = true;
        helper.clearingPattern = INVALID_FIELD_NAME_PATTERN;
        return helper;
    }

    static NamingHelper forFieldNamePostfix() {
        NamingHelper helper = new NamingHelper();
        helper.clearingPattern = INVALID_FIELD_NAME_POSTFIX_PATTERN;
        return helper;
    }

    static NamingHelper forNodeName() {
        NamingHelper helper = new NamingHelper();
        helper.lowercaseFirst = true;
        helper.clearingPattern = INVALID_NODE_NAME_NS_PATTERN;
        helper.removeInvalidNamespace = true;
        return helper;
    }

    static NamingHelper forPlainName() {
        NamingHelper helper = new NamingHelper();
        helper.clearingPattern = INVALID_PLAIN_NAME_PATTERN;
        return helper;
    }
}

