/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils;

import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.utils.NamingHelper;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class NamingUtil {
    private static final String PREFIX_GET = "get";
    private static final NamingHelper FIELD_HELPER = NamingHelper.forFieldName();
    private static final NamingHelper FIELD_PREFIX_HELPER = NamingHelper.forFieldNamePrefix();
    private static final NamingHelper FIELD_POSTFIX_HELPER = NamingHelper.forFieldNamePostfix();
    private static final NamingHelper NODE_NAME_HELPER = NamingHelper.forNodeName();
    private static final NamingHelper PLAIN_NAME_HELPER = NamingHelper.forPlainName();

    private NamingUtil() {
    }

    public static String getValidFieldName(String value) {
        return FIELD_HELPER.getValidName(value, "field");
    }

    public static String getValidFieldPrefix(String value) {
        return FIELD_PREFIX_HELPER.getValidName(value, "");
    }

    public static String getValidFieldPostfix(String value) {
        return FIELD_POSTFIX_HELPER.getValidName(value, "");
    }

    public static String getValidPlainName(String value) {
        return PLAIN_NAME_HELPER.getValidName(value, "");
    }

    public static String getValidNodeName(String value) {
        return NODE_NAME_HELPER.getValidName(value, "item");
    }

    public static String getValidNodeName(String value, String defaultValue) {
        return NODE_NAME_HELPER.getValidName(value, defaultValue);
    }

    public static String getUniqueName(String value, String defaultValue, Target context) {
        return NODE_NAME_HELPER.getUniqueName(value, defaultValue, context);
    }

    public static String getUniqueName(String value, String defaultValue, Element context) {
        return NODE_NAME_HELPER.getUniqueName(value, defaultValue, context);
    }

    public static String stripGetterPrefix(Source source) {
        String value = source.getName();
        if (source.adaptTo(Method.class) != null && StringUtils.startsWith((CharSequence)value, (CharSequence)PREFIX_GET)) {
            return Character.toLowerCase(value.charAt(PREFIX_GET.length())) + value.substring(PREFIX_GET.length() + 1);
        }
        return value;
    }
}

