/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils;

import com.exadel.aem.toolkit.api.annotations.main.ClassMember;
import com.exadel.aem.toolkit.api.annotations.widgets.accessory.Replace;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.markers._Default;
import com.exadel.aem.toolkit.api.markers._Super;
import com.exadel.aem.toolkit.plugin.adapters.ClassMemberSetting;
import com.exadel.aem.toolkit.plugin.adapters.MemberRankingSetting;
import com.exadel.aem.toolkit.plugin.sources.ModifiableMemberSource;
import com.exadel.aem.toolkit.plugin.utils.ordering.OrderingUtil;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

class ReplacementHelper {
    private static final SourceReplacingCollector SOURCE_REPLACING = new SourceReplacingCollector();
    private final List<Source> internal = new ArrayList<Source>();

    private ReplacementHelper() {
    }

    private List<Source> processInternal() {
        ArrayList<Source> result = new ArrayList<Source>(this.internal);
        Queue replacingEntries = result.stream().filter(entry -> entry.tryAdaptTo(Replace.class).isPresent()).sorted(OrderingUtil::compareByOrigin).collect(Collectors.toCollection(LinkedList::new));
        while (!replacingEntries.isEmpty()) {
            boolean alreadyReplaced;
            Source replacingEntry = (Source)replacingEntries.remove();
            Replace replace = (Replace)replacingEntry.adaptTo(Replace.class);
            ClassMemberSetting formerClassMemberAnnotation = new ClassMemberSetting(replace.value()).populateDefaults(((MemberSource)replacingEntry.adaptTo(MemberSource.class)).getDeclaringClass(), replacingEntry.getName());
            Source formerEntry = this.internal.stream().filter(formerClassMemberAnnotation::matches).findFirst().orElse(null);
            if (formerEntry == null || formerEntry.equals(replacingEntry)) continue;
            result.remove(replacingEntry);
            int insertPosition = result.indexOf(formerEntry);
            boolean bl = alreadyReplaced = insertPosition == -1;
            if (alreadyReplaced) {
                Source alreadyExistingReplacement = result.stream().filter(source -> ReplacementHelper.isSameReplacement(source, replacingEntry)).findFirst().orElse(null);
                if (alreadyExistingReplacement != null) {
                    insertPosition = result.indexOf(alreadyExistingReplacement);
                    result.remove(alreadyExistingReplacement);
                } else {
                    insertPosition = result.size();
                }
            }
            result.add(insertPosition, replacingEntry);
            if (((MemberRankingSetting)replacingEntry.adaptTo(MemberRankingSetting.class)).isUnset()) {
                int formerRank = ((MemberRankingSetting)formerEntry.adaptTo(MemberRankingSetting.class)).getRanking();
                ((MemberRankingSetting)replacingEntry.adaptTo(MemberRankingSetting.class)).setRanking(formerRank);
            }
            ((ModifiableMemberSource)replacingEntry.adaptTo(ModifiableMemberSource.class)).setDeclaringClass(((MemberSource)formerEntry.adaptTo(MemberSource.class)).getDeclaringClass());
            result.remove(formerEntry);
            replacingEntries.remove(formerEntry);
        }
        return result;
    }

    public static Collector<Source, ReplacementHelper, List<Source>> processSourceReplace() {
        return SOURCE_REPLACING;
    }

    private static boolean isSameReplacement(Source existing, Source contender) {
        if (!existing.tryAdaptTo(Replace.class).isPresent() || !contender.tryAdaptTo(Replace.class).isPresent()) {
            return false;
        }
        ClassMember firstMemberName = ((Replace)existing.adaptTo(Replace.class)).value();
        ClassMember secondMemberName = ((Replace)contender.adaptTo(Replace.class)).value();
        if (!firstMemberName.value().equals(secondMemberName.value())) {
            return false;
        }
        return ((MemberSource)existing.adaptTo(MemberSource.class)).getDeclaringClass().equals(ReplacementHelper.getReferencedReplacementClass(contender));
    }

    private static Class<?> getReferencedReplacementClass(Source source) {
        Class result = ((Replace)source.adaptTo(Replace.class)).value().source();
        if (_Default.class.equals((Object)result)) {
            return ((MemberSource)source.adaptTo(MemberSource.class)).getDeclaringClass();
        }
        if (_Super.class.equals((Object)result)) {
            return ((MemberSource)source.adaptTo(MemberSource.class)).getDeclaringClass().getSuperclass();
        }
        return result;
    }

    private static class SourceReplacingCollector
    implements Collector<Source, ReplacementHelper, List<Source>> {
        private SourceReplacingCollector() {
        }

        @Override
        public Supplier<ReplacementHelper> supplier() {
            return () -> new ReplacementHelper();
        }

        @Override
        public BiConsumer<ReplacementHelper, Source> accumulator() {
            return (left, right) -> ((ReplacementHelper)left).internal.add(right);
        }

        @Override
        public BinaryOperator<ReplacementHelper> combiner() {
            return (left, right) -> {
                ((ReplacementHelper)left).internal.addAll(((ReplacementHelper)right).internal);
                return left;
            };
        }

        @Override
        public Function<ReplacementHelper, List<Source>> finisher() {
            return rec$ -> ((ReplacementHelper)rec$).processInternal();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Sets.immutableEnumSet((Enum)Collector.Characteristics.UNORDERED, (Enum[])new Collector.Characteristics[0]);
        }
    }
}

