/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils;

import com.exadel.aem.toolkit.api.annotations.editconfig.ChildEditConfig;
import com.exadel.aem.toolkit.api.annotations.editconfig.EditConfig;
import com.exadel.aem.toolkit.api.annotations.main.AemComponent;
import com.exadel.aem.toolkit.api.annotations.main.DesignDialog;
import com.exadel.aem.toolkit.api.annotations.main.Dialog;
import com.exadel.aem.toolkit.api.annotations.main.HtmlTag;
import com.exadel.aem.toolkit.api.annotations.meta.AnnotationRendering;
import com.exadel.aem.toolkit.api.annotations.meta.PropertyRendering;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.sources.Sources;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class ScopeUtil {
    private static final List<Class<? extends Annotation>> ENTRY_POINT_ANNOTATION_TYPES = Arrays.asList(AemComponent.class, Dialog.class, DesignDialog.class, EditConfig.class, ChildEditConfig.class, HtmlTag.class);

    private ScopeUtil() {
    }

    public static boolean fits(String scope, Member member) {
        List<String> activeScopes = Sources.fromMember(member).tryAdaptTo(PropertyRendering.class).map(PropertyRendering::scope).map(Arrays::asList).orElse(Collections.singletonList(""));
        return activeScopes.contains(scope) || activeScopes.contains("");
    }

    public static boolean fits(String scope, Annotation annotation, Annotation[] context) {
        AnnotationRendering annotationRendering = Metadata.from(annotation).getAnnotation(AnnotationRendering.class);
        if (annotationRendering == null) {
            return false;
        }
        Object[] scopes = annotationRendering.scope();
        if (scopes.length == 1 && scopes[0].equals("") && ArrayUtils.isNotEmpty((Object[])context)) {
            scopes = ScopeUtil.designate((Class[])Arrays.stream(context).map(Annotation::annotationType).toArray(Class[]::new));
        }
        return ArrayUtils.contains((Object[])scopes, (Object)scope) || ArrayUtils.contains((Object[])scopes, (Object)"");
    }

    public static boolean fits(String scope, String[] others) {
        if (ArrayUtils.contains((Object[])others, (Object)scope)) {
            return true;
        }
        return ArrayUtils.contains((Object[])others, (Object)"");
    }

    public static String[] designate(Class<?>[] types) {
        if (ArrayUtils.isEmpty((Object[])types)) {
            return new String[]{""};
        }
        if (ArrayUtils.contains((Object[])types, Dialog.class) && !ArrayUtils.contains((Object[])types, DesignDialog.class)) {
            return new String[]{"_cq_dialog.xml"};
        }
        for (Class<? extends Annotation> annotationType2 : ENTRY_POINT_ANNOTATION_TYPES) {
            if (!ArrayUtils.contains((Object[])types, annotationType2)) continue;
            return annotationType2.getDeclaredAnnotation(AnnotationRendering.class).scope();
        }
        List<String> scopesByAnnotationRendering = Arrays.stream(types).flatMap(annotationType -> annotationType.isAnnotationPresent(AnnotationRendering.class) ? Arrays.stream(annotationType.getDeclaredAnnotation(AnnotationRendering.class).scope()) : Stream.of("")).distinct().collect(Collectors.toList());
        if (types.length == 1 || scopesByAnnotationRendering.size() == 1) {
            return scopesByAnnotationRendering.toArray(new String[0]);
        }
        return new String[]{""};
    }
}

