/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils;

import com.google.common.collect.ImmutableMap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final String TYPE_TOKEN_TEMPLATE = "{%s}";
    private static final String TYPED_VALUE_TEMPLATE = "{%s}%s";
    private static final String ARRAY_TEMPLATE = "[%s]";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final String ESCAPE_STRING = "\\";
    private static final String SPLITTING_PATTERN = "\\s*,\\s*";
    private static final Pattern ATTRIBUTE_LIST_PATTERN = Pattern.compile("^\\[.+]$");
    private static final Function<Object, String> DEFAULT_CONVERSION = Object::toString;
    private static final Map<Class<?>, Function<Object, String>> CONVERSIONS = ImmutableMap.of(Date.class, v -> new SimpleDateFormat(DATE_FORMAT).format(v));

    private StringUtil() {
    }

    public static <T> String format(T value, Class<?> valueType) {
        if (value == null) {
            return "";
        }
        if (String.class.equals(valueType)) {
            return value.toString();
        }
        String effectiveString = CONVERSIONS.getOrDefault(valueType, DEFAULT_CONVERSION).apply(value);
        return String.format(TYPED_VALUE_TEMPLATE, valueType.getSimpleName(), effectiveString);
    }

    public static <T> String format(T[] value, Class<?> valueType) {
        if (value == null || value.length == 0) {
            return "";
        }
        return StringUtil.format(Arrays.stream(value).collect(Collectors.toList()), valueType);
    }

    public static <T> String format(Collection<T> value, Class<?> valueType) {
        Function<Object, String> conversion = CONVERSIONS.getOrDefault(valueType, DEFAULT_CONVERSION);
        return StringUtil.format(value, valueType, conversion);
    }

    private static <T> String format(Collection<T> value, Class<?> valueType, Function<Object, String> conversion) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        String collectionPart = value.stream().filter(Objects::nonNull).map(conversion).map(s -> s.startsWith("[") && s.endsWith("]") ? ESCAPE_STRING + s : s).collect(Collectors.joining(","));
        if (String.class.equals(valueType)) {
            return String.format(ARRAY_TEMPLATE, collectionPart);
        }
        return String.format(TYPE_TOKEN_TEMPLATE, valueType.getSimpleName()) + String.format(ARRAY_TEMPLATE, collectionPart);
    }

    public static boolean isCollection(String value) {
        return ATTRIBUTE_LIST_PATTERN.matcher(value).matches();
    }

    public static Set<String> parseSet(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return new HashSet<String>();
        }
        return new LinkedHashSet<String>(Arrays.asList(StringUtils.strip((String)value, (String)"[]").split(SPLITTING_PATTERN)));
    }

    public static List<String> parseCollection(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return new ArrayList<String>();
        }
        return Arrays.asList(StringUtils.strip((String)value, (String)"[]").split(SPLITTING_PATTERN));
    }

    public static String escapeArray(String value) {
        String result = value;
        for (String bracket : new String[]{"[", "]"}) {
            result = StringUtils.replace((String)result, (String)bracket, (String)(ESCAPE_STRING + bracket));
        }
        return result;
    }
}

