/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils.ordering;

import java.util.ArrayList;
import java.util.List;

class Orderable<T> {
    private final T value;
    private final String id;
    private final int rank;
    private boolean placeAnnotated;
    private List<Orderable<T>> before = new ArrayList<Orderable<T>>();
    private List<Orderable<T>> after = new ArrayList<Orderable<T>>();
    private int positionInAllNodes;

    Orderable(T value, String id) {
        this(value, id, 0);
    }

    Orderable(T value, String id, int rank) {
        this.id = id;
        this.value = value;
        this.rank = rank;
    }

    public String getId() {
        return this.id;
    }

    public int getRank() {
        return this.rank;
    }

    public List<Orderable<T>> getBefore() {
        return this.before;
    }

    void setBefore(List<Orderable<T>> before) {
        this.before = before;
    }

    public List<Orderable<T>> getAfter() {
        return this.after;
    }

    public void setAfter(List<Orderable<T>> after) {
        this.after = after;
    }

    public T getValue() {
        return this.value;
    }

    public int getPosition() {
        return this.positionInAllNodes;
    }

    public void setPosition(int position) {
        this.positionInAllNodes = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Orderable orderable = (Orderable)o;
        return this.id.equals(orderable.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

