/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils.ordering;

import com.exadel.aem.toolkit.api.annotations.layouts.Place;
import com.exadel.aem.toolkit.api.annotations.main.ClassMember;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Handles;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.markers._Default;
import com.exadel.aem.toolkit.api.markers._Super;
import com.exadel.aem.toolkit.plugin.adapters.MemberRankingSetting;
import com.exadel.aem.toolkit.plugin.utils.ordering.Orderable;
import com.exadel.aem.toolkit.plugin.utils.ordering.TopologicalSorter;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class OrderingUtil {
    private static final String BUILTIN_HANDLERS_ROOT = "com.exadel.aem.toolkit.plugin.handlers";

    private OrderingUtil() {
    }

    public static <T> List<T> sortHandlers(List<T> handlers) {
        if (handlers == null || handlers.size() < 2) {
            return handlers;
        }
        ArrayList orderableHandlers = new ArrayList();
        ArrayList<T> nonOrderableHandlers = new ArrayList<T>();
        for (T handler : handlers) {
            if (handler.getClass().isAnnotationPresent(Handles.class)) {
                orderableHandlers.add(new Orderable<T>(handler, handler.getClass().getName()));
                continue;
            }
            nonOrderableHandlers.add(handler);
        }
        for (int i = 0; i < orderableHandlers.size(); ++i) {
            Handles handles = ((Orderable)orderableHandlers.get(i)).getValue().getClass().getDeclaredAnnotation(Handles.class);
            if (!_Default.class.equals((Object)handles.before())) {
                Orderable before = OrderingUtil.findSibling(handles.before().getName(), orderableHandlers);
                ((Orderable)orderableHandlers.get(i)).getBefore().add(before);
                if (before != null) {
                    before.getAfter().add(orderableHandlers.get(i));
                }
            }
            if (_Default.class.equals((Object)handles.after())) continue;
            Orderable after = OrderingUtil.findSibling(handles.after().getName(), orderableHandlers);
            ((Orderable)orderableHandlers.get(i)).getAfter().add(after);
            if (after == null) continue;
            after.getBefore().add(0, orderableHandlers.get(i));
        }
        Stream<Object> sortedStream = new TopologicalSorter(orderableHandlers).topologicalSort().stream().map(Orderable::getValue);
        return Streams.concat((Stream[])new Stream[]{nonOrderableHandlers.stream(), sortedStream}).collect(Collectors.toList());
    }

    public static List<Source> sortMembers(List<Source> sources) {
        if (sources == null || sources.size() < 2) {
            return sources;
        }
        ArrayList list = new ArrayList(sources.size());
        for (Source source : sources.stream().sorted(OrderingUtil::compareByRank).collect(Collectors.toList())) {
            list.add(new Orderable<Source>(source, OrderingUtil.createId(source), ((MemberRankingSetting)source.adaptTo(MemberRankingSetting.class)).getRanking()));
        }
        for (int i = 0; i < sources.size(); ++i) {
            ClassMember classMemberAfter;
            Place place = (Place)sources.get(i).adaptTo(Place.class);
            if (place == null) continue;
            ClassMember classMemberBefore = place.before();
            if (StringUtils.isNotBlank((CharSequence)classMemberBefore.value())) {
                Orderable before = OrderingUtil.findSibling(OrderingUtil.createId(classMemberBefore, ((MemberSource)sources.get(i).adaptTo(MemberSource.class)).getDeclaringClass()), list);
                ((Orderable)list.get(i)).getBefore().add(before);
                if (before != null) {
                    before.getAfter().add(list.get(i));
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(classMemberAfter = place.after()).value())) continue;
            Orderable after = OrderingUtil.findSibling(OrderingUtil.createId(classMemberAfter, ((MemberSource)sources.get(i).adaptTo(MemberSource.class)).getDeclaringClass()), list);
            ((Orderable)list.get(i)).getAfter().add(after);
            if (after == null) continue;
            after.getBefore().add(0, list.get(i));
        }
        return new TopologicalSorter(list).topologicalSort().stream().map(Orderable::getValue).collect(Collectors.toList());
    }

    private static <T> Orderable<T> findSibling(String id, List<Orderable<T>> scope) {
        for (Orderable<T> orderable : scope) {
            if (!orderable.getId().equals(id)) continue;
            return orderable;
        }
        return null;
    }

    private static String createId(Source source) {
        return OrderingUtil.createId(((MemberSource)source.adaptTo(MemberSource.class)).getDeclaringClass(), source.getName());
    }

    private static String createId(ClassMember classMember, Class<?> defaultClass) {
        if (_Default.class.equals((Object)classMember.source())) {
            return OrderingUtil.createId(defaultClass, classMember.value());
        }
        if (_Super.class.equals((Object)classMember.source())) {
            return OrderingUtil.createId(defaultClass.getSuperclass(), classMember.value());
        }
        return OrderingUtil.createId(classMember.source(), classMember.value());
    }

    private static String createId(Class<?> targetClass, String name) {
        return targetClass.getName() + "." + name;
    }

    public static int compareByOrigin(Source f1, Source f2) {
        Class f2Class;
        if (f1 != null && f2 == null) {
            return -1;
        }
        if (f1 == null && f2 != null) {
            return 1;
        }
        if (f1 == null) {
            return 0;
        }
        Class f1Class = ((MemberSource)f1.adaptTo(MemberSource.class)).getDeclaringClass();
        if (f1Class != (f2Class = ((MemberSource)f2.adaptTo(MemberSource.class)).getDeclaringClass())) {
            if (ClassUtils.isAssignable((Class)f1Class, (Class)f2Class)) {
                return 1;
            }
            if (ClassUtils.isAssignable((Class)f2Class, (Class)f1Class)) {
                return -1;
            }
        }
        return 0;
    }

    public static int compareByOrigin(Handler h1, Handler h2) {
        if (h1 != null && h2 == null) {
            return -1;
        }
        if (h1 == null && h2 != null) {
            return 1;
        }
        if (h1 == null) {
            return 0;
        }
        if (h1.getClass().getPackage().getName().startsWith(BUILTIN_HANDLERS_ROOT) && !h2.getClass().getPackage().getName().startsWith(BUILTIN_HANDLERS_ROOT)) {
            return -1;
        }
        if (!h1.getClass().getPackage().getName().startsWith(BUILTIN_HANDLERS_ROOT) && h2.getClass().getPackage().getName().startsWith(BUILTIN_HANDLERS_ROOT)) {
            return 1;
        }
        return h1.getClass().getName().compareTo(h2.getClass().getName());
    }

    private static int compareByRank(Source f1, Source f2) {
        int rank2;
        if (f1 != null && f2 == null) {
            return -1;
        }
        if (f1 == null && f2 != null) {
            return 1;
        }
        if (f1 == null) {
            return 0;
        }
        int rank1 = ((MemberRankingSetting)f1.adaptTo(MemberRankingSetting.class)).getRanking();
        if (rank1 != (rank2 = ((MemberRankingSetting)f2.adaptTo(MemberRankingSetting.class)).getRanking())) {
            return Integer.compare(rank1, rank2);
        }
        if (((MemberSource)f1.adaptTo(MemberSource.class)).getDeclaringClass() != ((MemberSource)f2.adaptTo(MemberSource.class)).getDeclaringClass()) {
            if (ClassUtils.isAssignable((Class)((MemberSource)f1.adaptTo(MemberSource.class)).getDeclaringClass(), (Class)((MemberSource)f2.adaptTo(MemberSource.class)).getDeclaringClass())) {
                return 1;
            }
            if (ClassUtils.isAssignable((Class)((MemberSource)f2.adaptTo(MemberSource.class)).getDeclaringClass(), (Class)((MemberSource)f1.adaptTo(MemberSource.class)).getDeclaringClass())) {
                return -1;
            }
        }
        return 0;
    }
}

