/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.utils.ordering;

import com.exadel.aem.toolkit.plugin.utils.ordering.Orderable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

class TopologicalSorter<T> {
    private final List<Orderable<T>> nodes;

    TopologicalSorter(List<Orderable<T>> nodes) {
        this.nodes = nodes;
    }

    public List<Orderable<T>> topologicalSort() {
        ArrayList<Orderable<T>> sorted = new ArrayList<Orderable<T>>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            Orderable<T> orderable = this.nodes.get(i);
            LinkedList<Orderable<T>> temp = new LinkedList<Orderable<T>>();
            Deque<Orderable<T>> after = this.after(orderable, new ArrayList<Orderable<T>>());
            while (!after.isEmpty()) {
                Orderable<T> tOrderable = after.removeLast();
                if (sorted.contains(tOrderable) || temp.contains(tOrderable)) continue;
                temp.addFirst(tOrderable);
            }
            Deque<Orderable<T>> before = this.before(orderable, new ArrayList<Orderable<T>>());
            while (!before.isEmpty()) {
                Orderable<T> tOrderable = before.removeFirst();
                if (sorted.contains(tOrderable) || temp.contains(tOrderable)) continue;
                temp.addLast(tOrderable);
            }
            if (!sorted.contains(orderable) && !temp.contains(orderable)) {
                temp.addLast(orderable);
            }
            sorted.addAll(temp);
        }
        return sorted;
    }

    private Deque<Orderable<T>> after(Orderable<T> orderable, List<Orderable<T>> values) {
        LinkedList<Orderable<T>> deque = new LinkedList<Orderable<T>>();
        if (orderable == null) {
            return deque;
        }
        for (Orderable<T> orderable1 : orderable.getAfter()) {
            if (values.contains(orderable1)) continue;
            values.add(orderable1);
            Deque<Orderable<T>> after = this.after(orderable1, values);
            while (!after.isEmpty()) {
                deque.addFirst(after.removeLast());
            }
            Deque<Orderable<T>> before = this.before(orderable1, values);
            while (!before.isEmpty()) {
                Orderable<T> tOrderable = before.removeFirst();
                if (deque.contains(tOrderable)) continue;
                deque.addLast(tOrderable);
            }
        }
        if (!deque.contains(orderable)) {
            deque.addLast(orderable);
        }
        return deque;
    }

    private Deque<Orderable<T>> before(Orderable<T> orderable, List<Orderable<T>> values) {
        LinkedList<Orderable<T>> deque = new LinkedList<Orderable<T>>();
        if (orderable == null) {
            return deque;
        }
        for (Orderable<T> orderable1 : orderable.getBefore()) {
            if (values.contains(orderable1)) continue;
            values.add(orderable1);
            Deque<Orderable<T>> after = this.after(orderable1, values);
            while (!after.isEmpty()) {
                deque.addFirst(after.removeLast());
            }
            Deque<Orderable<T>> before = this.before(orderable1, values);
            while (!before.isEmpty()) {
                Orderable<T> tOrderable = before.removeFirst();
                if (deque.contains(tOrderable)) continue;
                deque.addLast(tOrderable);
            }
        }
        if (!deque.contains(orderable)) {
            deque.addFirst(orderable);
        }
        return deque;
    }
}

