/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.validators;

import com.exadel.aem.toolkit.api.annotations.meta.Validator;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.StringUtils;

public class AllNotBlankValidator
implements Validator {
    private static final String MSG_STRINGS_NOT_BLANK = "string properties must not be blank";

    public boolean test(Object value) {
        if (!this.isApplicableTo(value)) {
            return false;
        }
        return Metadata.from((Annotation)value).stream(false, false).filter(prop -> String.class.equals(prop.getType())).allMatch(prop -> prop.getValue() != null && StringUtils.isNotBlank((CharSequence)prop.getValue().toString()));
    }

    public boolean isApplicableTo(Object value) {
        return value instanceof Annotation;
    }

    public String getWarningMessage() {
        return MSG_STRINGS_NOT_BLANK;
    }
}

