/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.validators;

import com.exadel.aem.toolkit.api.annotations.widgets.rte.Characters;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.validators.AllNotBlankValidator;

public class CharactersObjectValidator
extends AllNotBlankValidator {
    private static final String MSG_VALID_PARAMS_EXPECTED = "a character range (start < end) or entity definition must be set";
    private static final String METHOD_RANGE_START = "rangeStart";
    private static final String METHOD_RANGE_END = "rangeEnd";
    private static final String METHOD_NAME = "name";
    private static final String METHOD_ENTITY = "entity";

    @Override
    public boolean test(Object value) {
        if (super.test(value)) {
            return true;
        }
        if (!this.isApplicableTo(value)) {
            return false;
        }
        Characters characters = (Characters)value;
        return characters.rangeStart() > 0L && characters.rangeEnd() > characters.rangeStart();
    }

    @Override
    public boolean isApplicableTo(Object value) {
        return value instanceof Characters;
    }

    public void filter(Characters source) {
        Metadata metadata = Metadata.from(source);
        if (super.test(source)) {
            metadata.unsetValue(METHOD_RANGE_START);
            metadata.unsetValue(METHOD_RANGE_END);
        } else {
            metadata.unsetValue(METHOD_NAME);
            metadata.unsetValue(METHOD_ENTITY);
        }
    }

    @Override
    public String getWarningMessage() {
        return MSG_VALID_PARAMS_EXPECTED;
    }
}

