/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.validators;

import com.exadel.aem.toolkit.plugin.validators.NotBlankValidator;
import java.util.regex.Pattern;

public class JcrPathValidator
extends NotBlankValidator {
    private static final Pattern JCR_PATH_PATTERN = Pattern.compile("^(/[\\w:.-]+)+/?$");
    private static final Pattern PROP_INJECT_PATTERN = Pattern.compile("^\\$\\{\\w+(?:\\.\\w+)*}$");
    private static final String MSG_JCR_PATH_EXPECTED = "complete JCR path expected";

    @Override
    public boolean test(Object value) {
        if (!super.test(value)) {
            return false;
        }
        return JCR_PATH_PATTERN.matcher(value.toString()).matches() || PROP_INJECT_PATTERN.matcher(value.toString()).matches();
    }

    @Override
    public String getWarningMessage() {
        return MSG_JCR_PATH_EXPECTED;
    }
}

