/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.validators;

import com.exadel.aem.toolkit.plugin.validators.NumberValidator;

public class NonNegativeNumberValidator
extends NumberValidator {
    private static final String MSG_NON_NEGATIVE_EXPECTED = "number equal or greater than zero expected";

    @Override
    public boolean test(Object value) {
        if (!super.test(value)) {
            return false;
        }
        if ("".equals(value)) {
            return true;
        }
        return Double.parseDouble(value.toString()) >= 0.0;
    }

    @Override
    public String getWarningMessage() {
        return MSG_NON_NEGATIVE_EXPECTED;
    }
}

