/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.validators;

import com.exadel.aem.toolkit.api.annotations.meta.Validator;

public class NumberValidator
implements Validator {
    private static final String MSG_NUMBER_EXPECTED = "a numeric value or an empty string expected";

    public boolean test(Object value) {
        if (value == null) {
            return false;
        }
        if ("".equals(value)) {
            return true;
        }
        try {
            Double.valueOf(value.toString());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isApplicableTo(Object value) {
        return true;
    }

    public String getWarningMessage() {
        return MSG_NUMBER_EXPECTED;
    }
}

