/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.validators;

import com.exadel.aem.toolkit.plugin.validators.NonNegativeNumberValidator;
import org.apache.commons.lang3.StringUtils;

public class PositiveNumberValidator
extends NonNegativeNumberValidator {
    private static final String MSG_POSITIVE_EXPECTED = "number greater than zero expected";

    @Override
    public boolean test(Object value) {
        if (!super.test(value)) {
            return false;
        }
        return StringUtils.isNotEmpty((CharSequence)value.toString()) && Double.parseDouble(value.toString()) > 0.0;
    }

    @Override
    public String getWarningMessage() {
        return MSG_POSITIVE_EXPECTED;
    }
}

