/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.validators;

import com.exadel.aem.toolkit.api.annotations.meta.Validator;
import com.exadel.aem.toolkit.api.annotations.meta.ValueRestriction;
import com.exadel.aem.toolkit.plugin.exceptions.ValidationException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.Property;
import com.exadel.aem.toolkit.plugin.validators.PermissiveValidator;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class Validation {
    private static final String LOG_PLAIN_VALUE_PATTERN = "Property %s is set to a wrong value: '%s' provided, %s";
    private static final String LOG_ANNOTATION_PATTERN = "Annotation @%s(%s) is invalid: %s";
    private static final String ARGUMENT_LIST_OPENER = "(";
    private static final String ARGUMENT_LIST_FINISHER = ")";
    private static final Validator NO_RESTRICTION = new PermissiveValidator();
    private final Validator testRoutine;
    private String propertyPath;

    private Validation(Validator testRoutine) {
        this.testRoutine = testRoutine;
    }

    public boolean test(Object value) {
        if (!this.testRoutine.isApplicableTo(value)) {
            return true;
        }
        boolean result = this.testRoutine.test(value);
        if (!result) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ValidationException(this.getLogMessage(value), new Object[0]));
        }
        return result;
    }

    public static Validation forProperty(Property property) {
        String restriction = null;
        if (property.getAnnotation(ValueRestriction.class) != null) {
            restriction = property.getAnnotation(ValueRestriction.class).value();
        }
        Validation checker = new Validation(Validation.getTestRoutine(restriction));
        checker.propertyPath = property.getPath();
        return checker;
    }

    public static Validation forType(Class<? extends Annotation> type) {
        String restriction = type.isAnnotationPresent(ValueRestriction.class) ? type.getDeclaredAnnotation(ValueRestriction.class).value() : null;
        return new Validation(Validation.getTestRoutine(restriction));
    }

    public static Validation defaultChecker() {
        return new Validation(NO_RESTRICTION);
    }

    private static Validator getTestRoutine(String name) {
        return PluginRuntime.context().getReflection().getValidators().stream().filter(validator -> validator.getClass().getName().equals(name)).findFirst().orElse(NO_RESTRICTION);
    }

    private String getLogMessage(Object value) {
        if (value != null && ClassUtils.isAssignable(value.getClass(), Annotation.class)) {
            String argumentSubstring = StringUtils.substringBetween((String)value.toString(), (String)ARGUMENT_LIST_OPENER, (String)ARGUMENT_LIST_FINISHER);
            if (argumentSubstring == null) {
                argumentSubstring = value.toString();
            }
            return String.format(LOG_ANNOTATION_PATTERN, ((Annotation)value).annotationType().getSimpleName(), argumentSubstring, this.testRoutine.getWarningMessage());
        }
        return String.format(LOG_PLAIN_VALUE_PATTERN, this.propertyPath, value, this.testRoutine.getWarningMessage());
    }
}

