/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.writers;

import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.adapters.DomAdapter;
import com.exadel.aem.toolkit.plugin.handlers.Handlers;
import com.exadel.aem.toolkit.plugin.handlers.common.DomHandler;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.targets.Targets;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.BiConsumer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

abstract class PackageEntryWriter {
    private static final DomHandler DOM_HANDLER = new DomHandler();
    private final Transformer transformer;

    PackageEntryWriter(Transformer transformer) {
        this.transformer = transformer;
    }

    abstract String getScope();

    abstract boolean canProcess(Source var1);

    BiConsumer<Source, Target> getHandlers() {
        return Handlers.forScope(this.getScope());
    }

    Transformer getTransformer() {
        return this.transformer;
    }

    final void cleanUp(Path componentPath) {
        try {
            Path existingFilePath = componentPath.resolve(this.getScope());
            Files.deleteIfExists(existingFilePath);
            if (!".content.xml".equals(this.getScope())) {
                Path nestedFolderPath = componentPath.resolve(StringUtils.substringBeforeLast((String)this.getScope(), (String)"."));
                Path nestedFilePath = nestedFolderPath.resolve(".content.xml");
                Files.deleteIfExists(nestedFilePath);
                Files.deleteIfExists(nestedFolderPath);
            }
        }
        catch (IOException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)e);
        }
    }

    final void writeXml(Source source, Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path.resolve(this.getScope()), StandardOpenOption.CREATE);){
            this.writeXml(source, writer);
        }
        catch (IOException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)e);
        }
    }

    private void writeXml(Source source, Writer writer) {
        Document document = this.createDocument(source);
        try {
            this.transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (TransformerException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)e);
        }
    }

    private Document createDocument(Source source) {
        Target target = Targets.newRoot(this.getScope());
        this.getHandlers().accept(source, target);
        Document result = ((DomAdapter)target.adaptTo(DomAdapter.class)).composeDocument(PluginRuntime.context().newXmlUtility().getDocument());
        DOM_HANDLER.accept(source, result, this.getScope());
        return result;
    }
}

