/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.writers;

import com.exadel.aem.toolkit.api.annotations.main.WriteMode;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.plugin.exceptions.InvalidSettingException;
import com.exadel.aem.toolkit.plugin.exceptions.MissingResourceException;
import com.exadel.aem.toolkit.plugin.exceptions.PluginException;
import com.exadel.aem.toolkit.plugin.exceptions.ValidationException;
import com.exadel.aem.toolkit.plugin.maven.PluginInfo;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.sources.ComponentSource;
import com.exadel.aem.toolkit.plugin.utils.XmlFactory;
import com.exadel.aem.toolkit.plugin.writers.ContentXmlWriter;
import com.exadel.aem.toolkit.plugin.writers.CqChildEditConfigWriter;
import com.exadel.aem.toolkit.plugin.writers.CqDialogWriter;
import com.exadel.aem.toolkit.plugin.writers.CqEditConfigWriter;
import com.exadel.aem.toolkit.plugin.writers.CqHtmlTagWriter;
import com.exadel.aem.toolkit.plugin.writers.EmptyCqEditConfigWriter;
import com.exadel.aem.toolkit.plugin.writers.PackageEntryWriter;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;

public class PackageWriter
implements AutoCloseable {
    private static final String PACKAGE_EXTENSION = ".zip";
    private static final String FILESYSTEM_PREFIX = "jar:";
    private static final Map<String, String> FILESYSTEM_OPTIONS = ImmutableMap.of((Object)"create", (Object)"true");
    private static final String PACKAGE_INFO_DIRECTORY = "META-INF/etoolbox-authoring-kit";
    private static final String PACKAGE_INFO_FILE_NAME = "version.info";
    private static final String CANNOT_WRITE_TO_PACKAGE_EXCEPTION_MESSAGE = "Cannot write to package ";
    private static final String COMPONENT_DATA_MISSING_EXCEPTION_MESSAGE = "No data to build .content.xml file while processing component ";
    private static final String COMPONENT_PATH_MISSING_EXCEPTION_MESSAGE = "Component path missing in class ";
    private static final String INVALID_PROJECT_EXCEPTION_MESSAGE = "Invalid project";
    private static final String UNRECOGNIZED_MODULE_EXCEPTION_MESSAGE = "Unrecognized component module %s while processing component %s";
    private final FileSystem fileSystem;
    private final List<PackageEntryWriter> writers;
    private final EmptyCqEditConfigWriter emptyEditConfigWriter;

    private PackageWriter(FileSystem fileSystem, List<PackageEntryWriter> writers) {
        this.fileSystem = fileSystem;
        this.writers = writers;
        this.emptyEditConfigWriter = new EmptyCqEditConfigWriter(writers.get(0).getTransformer());
    }

    @Override
    public void close() {
        try {
            this.fileSystem.close();
        }
        catch (IOException e) {
            throw new PluginException(CANNOT_WRITE_TO_PACKAGE_EXCEPTION_MESSAGE, e);
        }
    }

    public void writeInfo(PluginInfo info) {
        Path rootPath = this.fileSystem.getRootDirectories().iterator().next();
        if (!Files.isWritable(rootPath)) {
            return;
        }
        Path infoDirPath = rootPath.resolve(PACKAGE_INFO_DIRECTORY);
        Path infoFilePath = infoDirPath.resolve(PACKAGE_INFO_FILE_NAME);
        try {
            Files.createDirectories(infoDirPath, new FileAttribute[0]);
            Files.deleteIfExists(infoFilePath);
            Files.createFile(infoFilePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)e);
        }
        try (BufferedWriter fileWriter = Files.newBufferedWriter(infoFilePath, StandardOpenOption.CREATE);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            printWriter.println(info.getName());
            printWriter.println(info.getVersion());
            printWriter.println(info.getTimestamp());
        }
        catch (IOException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)e);
        }
    }

    public boolean write(ComponentSource component) {
        if (StringUtils.isBlank((CharSequence)component.getPath())) {
            String exceptionMessage = COMPONENT_PATH_MISSING_EXCEPTION_MESSAGE + ((Class)component.adaptTo(Class.class)).getSimpleName();
            ValidationException validationException = new ValidationException(exceptionMessage, new Object[0]);
            PluginRuntime.context().getExceptionHandler().handle((Exception)validationException);
            return false;
        }
        Path fileSystemPath = this.fileSystem.getPath(component.getPath(), new String[0]);
        if (!this.ensureTargetPath(component, fileSystemPath)) {
            return false;
        }
        Map<PackageEntryWriter, Source> viewsByWriter = this.getViewsByWriter(component);
        if (viewsByWriter.keySet().stream().noneMatch(writer -> ".content.xml".equals(writer.getScope()))) {
            InvalidSettingException e = new InvalidSettingException(COMPONENT_DATA_MISSING_EXCEPTION_MESSAGE + ((Class)component.adaptTo(Class.class)).getName());
            PluginRuntime.context().getExceptionHandler().handle((Exception)e);
        }
        if (viewsByWriter.keySet().stream().noneMatch(writer -> StringUtils.equalsAny((CharSequence)writer.getScope(), (CharSequence[])new CharSequence[]{"_cq_dialog.xml", "_cq_editConfig.xml", "_cq_design_dialog.xml", "_cq_childEditConfig.xml"}))) {
            viewsByWriter.put(this.emptyEditConfigWriter, component);
        }
        viewsByWriter.forEach((writer, view) -> {
            writer.cleanUp(fileSystemPath);
            writer.writeXml((Source)view, fileSystemPath);
        });
        return true;
    }

    private boolean ensureTargetPath(ComponentSource component, Path path) {
        if (!Files.exists(path, new LinkOption[0]) && component.getWriteMode() == WriteMode.CREATE) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException ex) {
                PluginRuntime.context().getExceptionHandler().handle((Exception)ex);
                return false;
            }
        }
        if (!Files.isWritable(path)) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new MissingResourceException(path));
            return false;
        }
        return true;
    }

    private Map<PackageEntryWriter, Source> getViewsByWriter(ComponentSource component) {
        HashMap<PackageEntryWriter, Source> result = new HashMap<PackageEntryWriter, Source>();
        for (Source view : component.getViews()) {
            List matchedWriters = this.writers.stream().filter(w -> w.canProcess(view)).collect(Collectors.toList());
            if (matchedWriters.isEmpty()) {
                InvalidSettingException ex = new InvalidSettingException(String.format(UNRECOGNIZED_MODULE_EXCEPTION_MESSAGE, view.getName(), component.getName()));
                PluginRuntime.context().getExceptionHandler().handle((Exception)ex);
            }
            for (PackageEntryWriter matchedWriter : matchedWriters) {
                if (result.get(matchedWriter) instanceof ComponentSource) {
                    ((ComponentSource)result.get(matchedWriter)).merge(view);
                    continue;
                }
                result.put(matchedWriter, view);
            }
        }
        return result;
    }

    public static PackageWriter forMavenProject(MavenProject project) {
        if (project == null) {
            throw new PluginException(INVALID_PROJECT_EXCEPTION_MESSAGE);
        }
        String packageFileName = project.getBuild().getFinalName() + PACKAGE_EXTENSION;
        Path path = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(packageFileName);
        URI uri = URI.create(FILESYSTEM_PREFIX + path.toUri());
        try {
            FileSystem fs = FileSystems.newFileSystem(uri, FILESYSTEM_OPTIONS);
            return PackageWriter.forFileSystem(fs, project.getBuild().getFinalName());
        }
        catch (IOException e) {
            throw new PluginException(CANNOT_WRITE_TO_PACKAGE_EXCEPTION_MESSAGE + project.getBuild().getFinalName(), e);
        }
    }

    public static PackageWriter forFileSystem(FileSystem fileSystem, String projectName) {
        List<PackageEntryWriter> writers;
        try {
            Transformer transformer = XmlFactory.newDocumentTransformer();
            writers = Arrays.asList(new ContentXmlWriter(transformer), new CqDialogWriter(transformer, "_cq_dialog.xml"), new CqDialogWriter(transformer, "_cq_design_dialog.xml"), new CqEditConfigWriter(transformer), new CqChildEditConfigWriter(transformer), new CqHtmlTagWriter(transformer));
        }
        catch (TransformerConfigurationException e) {
            throw new PluginException(CANNOT_WRITE_TO_PACKAGE_EXCEPTION_MESSAGE + projectName, e);
        }
        return new PackageWriter(fileSystem, writers);
    }
}

