/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.http;

import com.exasol.bucketfs.http.DummyTrustManager;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.net.http.HttpClient;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class HttpClientBuilder {
    private boolean raiseTlsErrors = true;
    private X509Certificate certificate;

    public HttpClientBuilder raiseTlsErrors(boolean raiseTlsErrors) {
        this.raiseTlsErrors = raiseTlsErrors;
        return this;
    }

    public HttpClientBuilder certificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public HttpClient build() {
        SSLContext sslContext = this.createSslContext();
        this.initializeSslContext(sslContext);
        return HttpClient.newBuilder().sslContext(sslContext).build();
    }

    private void initializeSslContext(SSLContext sslContext) {
        try {
            sslContext.init(null, this.createTrustManagers().orElse(null), null);
        }
        catch (KeyManagementException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-20").message("Unable to initialize TLS context while trying to create HTTP client for RPC communication.", new Object[0]).toString(), exception);
        }
    }

    private Optional<TrustManager[]> createTrustManagers() {
        if (!this.raiseTlsErrors && this.certificate != null) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-27").message("Setting raiseTlsErrors to false and using a certificate is mutually exclusive.", new Object[0]).mitigation("Either set raiseTlsErrors to true or remove the certificate.", new Object[0]).toString());
        }
        if (!this.raiseTlsErrors) {
            return Optional.of(this.createDummyTrustManagers());
        }
        if (this.certificate != null) {
            return Optional.of(this.createTrustManagerForCertificate());
        }
        return Optional.empty();
    }

    private TrustManager[] createDummyTrustManagers() {
        return new TrustManager[]{new DummyTrustManager()};
    }

    private TrustManager[] createTrustManagerForCertificate() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            keyStore.setCertificateEntry("caCert", this.certificate);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-25").message("Unable to create trust manager for given certificate", new Object[0]).toString());
        }
    }

    private SSLContext createSslContext() {
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-26").message("Unable to initialize TLS context while trying to create HTTP client for RPC communication.", new Object[0]).toString(), exception);
        }
    }
}

