/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.uploadnecessity;

import com.exasol.bucketfs.BucketAccessException;
import com.exasol.bucketfs.ReadOnlyBucket;
import com.exasol.bucketfs.uploadnecessity.ByteArrayToHexConverter;
import com.exasol.bucketfs.uploadnecessity.UploadNecessityCheckStrategy;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ChecksumUploadNecessityCheckStrategy
implements UploadNecessityCheckStrategy {
    private static final String UDF_SCHEMA = "BUCKET_FS_JAVA_HELPER";
    private static final String UDF_NAME = "BUCKET_FS_CHECKSUM";
    private static final String UDF_FULL_NAME = "BUCKET_FS_JAVA_HELPER.BUCKET_FS_CHECKSUM";
    private static final int ONE_MEGABYTE = 1000000;
    private final Connection sqlConnection;

    public ChecksumUploadNecessityCheckStrategy(Connection sqlConnection) {
        this.sqlConnection = sqlConnection;
    }

    @Override
    public boolean isUploadNecessary(Path file, String fullFileNameInBucketFs, ReadOnlyBucket bucket) throws BucketAccessException {
        try {
            String[] parts = fullFileNameInBucketFs.split("/");
            String fileName = parts[parts.length - 1];
            List<String> filesInBucketDirectory = bucket.listContents(this.getDirectory(parts));
            if (Files.size(file) > 1000000L && filesInBucketDirectory.contains(fileName)) {
                return !this.localSha512Checksum(file).equals(this.getSha512Checksum(fullFileNameInBucketFs, bucket));
            }
            return true;
        }
        catch (BucketAccessException | IOException | NoSuchAlgorithmException exception) {
            throw new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-17").message("Failed to check if we need to upload {{file}}.", new Object[]{fullFileNameInBucketFs}).toString(), exception);
        }
    }

    private String getDirectory(String[] parts) {
        String directory = Arrays.stream(parts).limit((long)parts.length - 1L).collect(Collectors.joining("/"));
        if (directory.startsWith("/")) {
            return directory.substring(1);
        }
        return directory;
    }

    private String localSha512Checksum(Path localPath) throws NoSuchAlgorithmException, IOException {
        MessageDigest checksumBuilder = MessageDigest.getInstance("SHA-512");
        try (InputStream inputStream = Files.newInputStream(localPath, new OpenOption[0]);
             DigestInputStream checksumBuildingStream = new DigestInputStream(inputStream, checksumBuilder);){
            byte[] buffer = new byte[1000];
            while (checksumBuildingStream.read(buffer) != -1) {
            }
        }
        return ByteArrayToHexConverter.toHex(checksumBuilder.digest());
    }

    /*
     * Exception decompiling
     */
    public String getSha512Checksum(String fileInBucketFs, ReadOnlyBucket bucket) throws BucketAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void installChecksumUdf() throws BucketAccessException {
        try (Statement statement = this.sqlConnection.createStatement();){
            statement.executeUpdate("CREATE SCHEMA IF NOT EXISTS BUCKET_FS_JAVA_HELPER;");
            statement.executeUpdate(this.getChecksumUdfStatement());
        }
        catch (SQLException exception) {
            throw new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-14").message("Failed to install sha-512 checksum UDF. This UDF is required by bucketfs-java for building the checksum of files in BucketFS.", new Object[0]).toString(), exception);
        }
    }

    private void uninstallChecksumUdf() throws BucketAccessException {
        try (Statement statement = this.sqlConnection.createStatement();){
            statement.executeUpdate("DROP SCRIPT  BUCKET_FS_JAVA_HELPER.BUCKET_FS_CHECKSUM;");
            statement.executeUpdate("DROP SCHEMA  BUCKET_FS_JAVA_HELPER;");
        }
        catch (SQLException exception) {
            throw new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-16").message("Failed to uninstall sha-512 checksum UDF.", new Object[0]).toString(), exception);
        }
    }

    private String getChecksumUdfStatement() {
        try {
            byte[] pythonScriptAsBytes = Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("checksumUdf.py")).readAllBytes();
            String pythonScript = new String(pythonScriptAsBytes, StandardCharsets.UTF_8);
            return "CREATE OR REPLACE PYTHON3 SCALAR SCRIPT BUCKET_FS_JAVA_HELPER.BUCKET_FS_CHECKSUM(my_path VARCHAR(2000)) RETURNS VARCHAR(256) AS\n" + pythonScript + "\n/";
        }
        catch (IOException | NullPointerException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-BFSJ-13").message("Failed to get Python UDF from resources.", new Object[0]).ticketMitigation().toString(), exception);
        }
    }
}

