/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.config;

import com.exasol.config.BucketConfiguration;
import java.util.HashMap;
import java.util.Map;

public class BucketFsServiceConfiguration {
    private final String name;
    private final int httpPort;
    private final int httpsPort;
    private final Map<String, BucketConfiguration> bucketConfigurations;

    private BucketFsServiceConfiguration(Builder builder) {
        this.name = builder.name;
        this.httpPort = builder.httpPort;
        this.httpsPort = builder.httpsPort;
        this.bucketConfigurations = builder.bucketConfigurations;
    }

    public String getName() {
        return this.name;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public BucketConfiguration getBucketConfiguration(String bucketName) {
        if (this.bucketConfigurations.containsKey(bucketName)) {
            return this.bucketConfigurations.get(bucketName);
        }
        throw new IllegalArgumentException("Bucket '" + bucketName + "' does not exist in configuration");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name = "bfsdefault";
        private int httpPort = 0;
        private int httpsPort = 0;
        private final Map<String, BucketConfiguration> bucketConfigurations = new HashMap<String, BucketConfiguration>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder httpPort(int httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public Builder httpsPort(int httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        public Builder addBucketConfiguration(BucketConfiguration bucketConfiguration) {
            this.bucketConfigurations.put(bucketConfiguration.getName(), bucketConfiguration);
            return this;
        }

        public BucketFsServiceConfiguration build() {
            return new BucketFsServiceConfiguration(this);
        }
    }
}

