/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs;

import com.exasol.bucketfs.BucketAccessException;
import com.exasol.bucketfs.BucketOperation;
import com.exasol.bucketfs.HttpResponseEvaluator;
import com.exasol.bucketfs.ReadOnlyBucket;
import com.exasol.bucketfs.http.HttpClientBuilder;
import com.exasol.bucketfs.list.BucketContentLister;
import com.exasol.bucketfs.list.ListingRetriever;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class ReadEnabledBucket
implements ReadOnlyBucket {
    private static final Logger LOGGER = Logger.getLogger(ReadEnabledBucket.class.getName());
    private static final String BUCKET_ROOT = "";
    protected final String serviceName;
    protected final String bucketName;
    protected final String protocol;
    protected final String host;
    protected final int port;
    protected final String readPassword;
    protected final Map<String, Instant> uploadHistory = new HashMap<String, Instant>();
    private final HttpClient client;

    protected ReadEnabledBucket(Builder<? extends Builder<?>> builder) {
        this.serviceName = Objects.requireNonNull(builder.serviceName, "serviceName");
        this.bucketName = Objects.requireNonNull(builder.bucketName, "bucketName");
        this.protocol = Objects.requireNonNull(builder.protocol, "protocol");
        this.host = Objects.requireNonNull(builder.host, "host");
        this.port = builder.port;
        this.readPassword = builder.readPassword;
        this.client = builder.httpClientBuilder.build();
    }

    @Override
    public String getBucketFsName() {
        return this.serviceName;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public String getFullyQualifiedBucketName() {
        return this.serviceName + "/" + this.bucketName;
    }

    @Override
    public String getReadPassword() {
        return this.readPassword;
    }

    @Override
    public List<String> listContents() throws BucketAccessException {
        return this.listContents(BUCKET_ROOT, false);
    }

    @Override
    public List<String> listContentsRecursively() throws BucketAccessException {
        return this.listContents(BUCKET_ROOT, true);
    }

    @Override
    public List<String> listContents(String path) throws BucketAccessException {
        return this.listContents(path, false);
    }

    @Override
    public List<String> listContentsRecursively(String path) throws BucketAccessException {
        return this.listContents(path, true);
    }

    private List<String> listContents(String path, boolean recursive) throws BucketAccessException {
        URI uri = this.createPublicReadURI(BUCKET_ROOT);
        ListingRetriever contentLister = new ListingRetriever(this.client);
        return new BucketContentLister(uri, contentLister, this.readPassword).retrieve(ListingRetriever.removeLeadingSeparator(path), recursive);
    }

    private URI createPublicReadURI(String pathInBucket) {
        String suffix = this.bucketName + "/" + ListingRetriever.removeLeadingSeparator(pathInBucket);
        return ListingRetriever.publicReadUri(this.protocol, this.host, this.port, suffix);
    }

    protected String extendPathInBucketDownToFilename(Path localPath, String pathInBucket) {
        return pathInBucket.endsWith("/") ? pathInBucket + localPath.getFileName() : pathInBucket;
    }

    @Override
    public void downloadFile(String pathInBucket, Path localPath) throws BucketAccessException {
        URI uri = this.createPublicReadURI(pathInBucket);
        LOGGER.fine(() -> "Downloading  file from bucket '" + this + "' at '" + uri + "' to '" + localPath + "'");
        this.requestFileOnBucket(uri, localPath);
        LOGGER.fine(() -> "Successfully downloaded file to '" + localPath + "'");
    }

    private void requestFileOnBucket(URI uri, Path localPath) throws BucketAccessException {
        try {
            HttpRequest request = this.createGetRequest(uri);
            HttpResponse<Path> response = this.client.send(request, HttpResponse.BodyHandlers.ofFile(localPath));
            HttpResponseEvaluator.evaluate(uri, BucketOperation.DOWNLOAD, response.statusCode());
        }
        catch (IOException exception) {
            throw BucketAccessException.downloadIoException(uri, BucketOperation.DOWNLOAD, exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw BucketAccessException.downloadInterruptedException(uri, BucketOperation.DOWNLOAD);
        }
    }

    private HttpRequest createGetRequest(URI uri) {
        return HttpRequest.newBuilder(uri).GET().header("Authorization", this.encodeBasicAuthForReading()).build();
    }

    @Override
    public String downloadFileAsString(String pathInBucket) throws BucketAccessException {
        URI uri = this.createPublicReadURI(pathInBucket);
        LOGGER.fine(() -> "Downloading  file from bucket '" + this + "' at '" + uri + "'");
        HttpResponse<String> response = this.requestFileOnBucketAsString(uri);
        HttpResponseEvaluator.evaluate(uri, BucketOperation.DOWNLOAD, response.statusCode());
        return response.body();
    }

    private HttpResponse<String> requestFileOnBucketAsString(URI uri) throws BucketAccessException {
        try {
            HttpRequest request = this.createGetRequest(uri);
            return this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException exception) {
            throw BucketAccessException.downloadIoException(uri, BucketOperation.DOWNLOAD, exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw BucketAccessException.downloadInterruptedException(uri, BucketOperation.DOWNLOAD);
        }
    }

    private String encodeBasicAuthForReading() {
        return "Basic " + Base64.getEncoder().encodeToString(("r:" + this.readPassword).getBytes());
    }

    protected HttpClient getClient() {
        return this.client;
    }

    public String toString() {
        return (this.serviceName == null ? this.port + ":" : this.serviceName + "/") + this.bucketName;
    }

    public static Builder<? extends Builder<?>> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        private String protocol = "http";
        private String serviceName;
        private String bucketName;
        private String host;
        private int port;
        private String readPassword;
        private final HttpClientBuilder httpClientBuilder;

        Builder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
        }

        protected Builder() {
            this(new HttpClientBuilder());
        }

        protected T self() {
            return (T)this;
        }

        public T serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this.self();
        }

        public T name(String bucketName) {
            this.bucketName = bucketName;
            return this.self();
        }

        public T useTls(boolean useTls) {
            this.protocol = useTls ? "https" : "http";
            return this.self();
        }

        public T host(String host) {
            this.host = host;
            return this.self();
        }

        public T port(int port) {
            this.port = port;
            return this.self();
        }

        @Deprecated
        public T httpPort(int port) {
            return this.port(port);
        }

        public T readPassword(String readPassword) {
            this.readPassword = readPassword;
            return this.self();
        }

        public T raiseTlsErrors(boolean raise) {
            this.httpClientBuilder.raiseTlsErrors(raise);
            return this.self();
        }

        public T certificate(X509Certificate certificate) {
            this.httpClientBuilder.certificate(certificate);
            return this.self();
        }

        public T allowAlternativeHostName(String hostName) {
            this.httpClientBuilder.allowAlternativeHostName(hostName);
            return this.self();
        }

        public T allowAlternativeIpAddress(String ipAddress) {
            this.httpClientBuilder.allowAlternativeIPAddress(ipAddress);
            return this.self();
        }

        public ReadOnlyBucket build() {
            return new ReadEnabledBucket(this);
        }
    }
}

