/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs;

import com.exasol.bucketfs.BucketAccessException;
import com.exasol.bucketfs.BucketOperation;
import com.exasol.bucketfs.HttpResponseEvaluator;
import com.exasol.bucketfs.ReadEnabledBucket;
import com.exasol.bucketfs.UnsynchronizedBucket;
import com.exasol.bucketfs.UploadResult;
import com.exasol.bucketfs.uploadnecessity.UploadAlwaysStrategy;
import com.exasol.bucketfs.uploadnecessity.UploadNecessityCheckStrategy;
import com.exasol.errorreporting.ExaError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Base64;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class WriteEnabledBucket
extends ReadEnabledBucket
implements UnsynchronizedBucket {
    private static final Logger LOGGER = Logger.getLogger(WriteEnabledBucket.class.getName());
    private final String writePassword;
    private UploadNecessityCheckStrategy uploadNecessityCheckStrategy = new UploadAlwaysStrategy();

    protected WriteEnabledBucket(Builder<? extends Builder<?>> builder) {
        super(builder);
        this.writePassword = builder.writePassword;
    }

    @Override
    public String getWritePassword() {
        return this.writePassword;
    }

    @Override
    public UploadResult uploadFileNonBlocking(Path localPath, String pathInBucket) throws BucketAccessException, FileNotFoundException {
        String extendedPathInBucket = this.extendPathInBucketDownToFilename(localPath, pathInBucket);
        if (this.uploadNecessityCheckStrategy.isUploadNecessary(localPath, pathInBucket, this)) {
            URI uri = this.createWriteUri(extendedPathInBucket);
            this.uploadWithBodyPublisher(uri, HttpRequest.BodyPublishers.ofFile(localPath), "file '" + localPath + "'");
            this.recordUploadInHistory(pathInBucket);
            return new UploadResult(true);
        }
        LOGGER.fine("Skipping upload since the " + this.uploadNecessityCheckStrategy.getClass().getSimpleName() + " decided it's not necessary.");
        return new UploadResult(false);
    }

    protected void uploadWithBodyPublisher(URI uri, HttpRequest.BodyPublisher publisher, String what) throws BucketAccessException {
        LOGGER.fine(() -> "Uploading " + what + " to bucket '" + this + "' at '" + uri + "'");
        this.requestUpload(uri, publisher);
        LOGGER.fine(() -> "Successfully uploaded " + what + " to '" + uri + "'");
    }

    private URI createWriteUri(String pathInBucket) throws BucketAccessException {
        try {
            return new URI(this.protocol, null, this.host, this.port, "/" + this.bucketName + "/" + pathInBucket, null, null).normalize();
        }
        catch (URISyntaxException exception) {
            throw new BucketAccessException("Unable to create write URI for path '" + pathInBucket + "'.", exception);
        }
    }

    private void requestUpload(URI uri, HttpRequest.BodyPublisher bodyPublisher) throws BucketAccessException {
        try {
            HttpRequest request = HttpRequest.newBuilder(uri).PUT(bodyPublisher).header("Authorization", this.encodeBasicAuth(true)).build();
            HttpResponse<String> response = this.getClient().send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            HttpResponseEvaluator.evaluate(uri, BucketOperation.UPLOAD, statusCode);
        }
        catch (IOException exception) {
            throw this.createUploadIoException(uri, exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw this.createUploadInterruptedException(uri);
        }
    }

    protected BucketAccessException createUploadIoException(URI uri, IOException exception) {
        return new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-7").message("I/O error trying to upload to {{URI}}", new Object[]{uri}).toString(), exception);
    }

    protected BucketAccessException createUploadInterruptedException(URI uri) {
        return new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-6").message("Interrupted trying to upload {{URI}}.", new Object[]{uri}).toString());
    }

    protected void recordUploadInHistory(String pathInBucket) {
        Instant now = Instant.now();
        LOGGER.finest(() -> "Recorded upload to '" + pathInBucket + "' at " + now + " in upload history");
        this.uploadHistory.put(pathInBucket, now);
    }

    private String encodeBasicAuth(boolean write) {
        return "Basic " + Base64.getEncoder().encodeToString((write ? "w:" + this.writePassword : "r:" + this.readPassword).getBytes());
    }

    @Override
    public void uploadStringContentNonBlocking(String content, String pathInBucket) throws BucketAccessException, TimeoutException {
        URI uri = this.createWriteUri(pathInBucket);
        String excerpt = content.length() > 20 ? content.substring(0, 20) + "..." : content;
        this.uploadWithBodyPublisher(uri, HttpRequest.BodyPublishers.ofString(content), "string content '" + excerpt + "'");
        this.recordUploadInHistory(pathInBucket);
    }

    @Override
    public void uploadInputStreamNonBlocking(Supplier<InputStream> inputStreamSupplier, String pathInBucket) throws BucketAccessException, TimeoutException {
        URI uri = this.createWriteUri(pathInBucket);
        this.uploadWithBodyPublisher(uri, HttpRequest.BodyPublishers.ofInputStream(inputStreamSupplier), "content of input stream");
        this.recordUploadInHistory(pathInBucket);
    }

    public static Builder<? extends Builder<?>> builder() {
        return new Builder();
    }

    @Override
    public void deleteFileNonBlocking(String filenameInBucket) throws BucketAccessException {
        try {
            URI uri = this.createWriteUri(filenameInBucket);
            HttpRequest request = HttpRequest.newBuilder(uri).DELETE().header("Authorization", this.encodeBasicAuth(true)).build();
            HttpResponse<String> response = this.getClient().send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            HttpResponseEvaluator.evaluate(uri, BucketOperation.DELETE, statusCode);
        }
        catch (IOException exception) {
            throw this.getDeleteFailedException(filenameInBucket, exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw this.getDeleteFailedException(filenameInBucket, exception);
        }
    }

    private BucketAccessException getDeleteFailedException(String filenameInBucket, Exception exception) {
        return new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-12").message("Failed to delete {{file}} from BucketFS.", new Object[]{filenameInBucket}).toString(), exception);
    }

    @Override
    public void setUploadNecessityCheckStrategy(UploadNecessityCheckStrategy uploadNecessityCheckStrategy) {
        this.uploadNecessityCheckStrategy = uploadNecessityCheckStrategy;
    }

    public static class Builder<T extends Builder<T>>
    extends ReadEnabledBucket.Builder<Builder<T>> {
        private String writePassword;

        @Override
        protected T self() {
            return (T)this;
        }

        public T writePassword(String writePassword) {
            this.writePassword = writePassword;
            return (T)this.self();
        }

        @Override
        public WriteEnabledBucket build() {
            return new WriteEnabledBucket(this);
        }
    }
}

