/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.http;

import com.exasol.bucketfs.http.DummyTrustManager;
import com.exasol.bucketfs.http.SubjectAltName;
import com.exasol.bucketfs.http.SubjectAltNameTrustManager;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.net.http.HttpClient;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class HttpClientBuilder {
    private static final Logger LOGGER = Logger.getLogger(HttpClientBuilder.class.getName());
    private boolean raiseTlsErrors = true;
    private X509Certificate certificate;
    private final List<SubjectAltName> altNames = new ArrayList<SubjectAltName>();

    public HttpClientBuilder raiseTlsErrors(boolean raiseTlsErrors) {
        this.raiseTlsErrors = raiseTlsErrors;
        return this;
    }

    public HttpClientBuilder certificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public HttpClientBuilder allowAlternativeHostName(String hostName) {
        return this.allowAltName(new SubjectAltName(SubjectAltName.Type.HOSTNAME, hostName));
    }

    public HttpClientBuilder allowAlternativeIPAddress(String ipAddress) {
        return this.allowAltName(new SubjectAltName(SubjectAltName.Type.IP, ipAddress));
    }

    private HttpClientBuilder allowAltName(SubjectAltName altName) {
        this.altNames.add(altName);
        return this;
    }

    public HttpClient build() {
        SSLContext sslContext = HttpClientBuilder.createSslContext();
        this.initializeSslContext(sslContext);
        return HttpClient.newBuilder().sslContext(sslContext).build();
    }

    private void initializeSslContext(SSLContext sslContext) {
        try {
            sslContext.init(null, this.createTrustManagers().orElse(null), null);
        }
        catch (KeyManagementException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-20").message("Unable to initialize TLS context while trying to create HTTP client for RPC communication.", new Object[0]).toString(), exception);
        }
    }

    private Optional<TrustManager[]> createTrustManagers() {
        if (!this.raiseTlsErrors && this.certificate != null) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-27").message("Setting raiseTlsErrors to false and using a certificate is mutually exclusive.", new Object[0]).mitigation("Either set raiseTlsErrors to true or remove the certificate.", new Object[0]).toString());
        }
        if (this.certificate == null && !this.altNames.isEmpty()) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-31").message("Using alternative subject names requires configuring a certificate.", new Object[0]).mitigation("Either specify a certificate or remove the alternative subject names.", new Object[0]).toString());
        }
        if (!this.raiseTlsErrors) {
            return Optional.of(HttpClientBuilder.createDummyTrustManagers());
        }
        if (this.certificate != null) {
            return Optional.of(HttpClientBuilder.createTrustManagerForCertificate(this.certificate)).map(this::allowAlternativeNames);
        }
        return Optional.empty();
    }

    private static TrustManager[] createDummyTrustManagers() {
        return new TrustManager[]{new DummyTrustManager()};
    }

    private static TrustManager[] createTrustManagerForCertificate(X509Certificate certificate) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            keyStore.setCertificateEntry("caCert", certificate);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            LOGGER.finest(() -> "Created " + trustManagers.length + " trust managers for certificate with subject '" + certificate.getSubjectX500Principal() + "': " + Arrays.toString(trustManagers));
            return trustManagers;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-25").message("Unable to create trust manager for given certificate", new Object[0]).toString());
        }
    }

    private TrustManager[] allowAlternativeNames(TrustManager[] trustManagers) {
        return (TrustManager[])Arrays.stream(trustManagers).map(this::allowAlternativeNames).toArray(TrustManager[]::new);
    }

    private TrustManager allowAlternativeNames(TrustManager trustManager) {
        return SubjectAltNameTrustManager.wrap(trustManager, this.altNames);
    }

    private static SSLContext createSslContext() {
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-26").message("Unable to initialize TLS context while trying to create HTTP client for RPC communication.", new Object[0]).toString(), exception);
        }
    }
}

