/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.jsonrpc;

import com.exasol.bucketfs.jsonrpc.AbstractJsonResponseCommand;
import com.exasol.bucketfs.jsonrpc.JsonMapper;
import com.exasol.bucketfs.jsonrpc.JsonRpcCommandExecutor;
import jakarta.json.JsonStructure;
import jakarta.json.bind.annotation.JsonbProperty;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class CreateBucketCommand
extends AbstractJsonResponseCommand<Void> {
    private static final String JOB_NAME = "bucket_add";
    private final Request request;

    CreateBucketCommand(JsonMapper jsonMapper, Request request) {
        super(jsonMapper, JOB_NAME);
        this.request = request;
    }

    @Override
    public Request getParameters() {
        return this.request;
    }

    @Override
    Void processResult(JsonStructure responsePayload) {
        return null;
    }

    static CreateBucketCommandBuilder builder(JsonRpcCommandExecutor executor, JsonMapper jsonMapper) {
        return new CreateBucketCommandBuilder(executor, jsonMapper);
    }

    public static final class CreateBucketCommandBuilder {
        private final JsonMapper jsonMapper;
        private final JsonRpcCommandExecutor executor;
        private String bucketFsName = null;
        private String bucketName = null;
        private boolean isPublic = false;
        private String readPassword = null;
        private String writePassword = null;

        private CreateBucketCommandBuilder(JsonRpcCommandExecutor executor, JsonMapper jsonMapper) {
            this.executor = executor;
            this.jsonMapper = jsonMapper;
        }

        public CreateBucketCommandBuilder bucketFsName(String bucketFsName) {
            this.bucketFsName = bucketFsName;
            return this;
        }

        public CreateBucketCommandBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public CreateBucketCommandBuilder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public CreateBucketCommandBuilder readPassword(String readPassword) {
            this.readPassword = readPassword;
            return this;
        }

        public CreateBucketCommandBuilder writePassword(String writePassword) {
            this.writePassword = writePassword;
            return this;
        }

        public void execute() {
            this.executor.execute(new CreateBucketCommand(this.jsonMapper, new Request(this)));
        }
    }

    public static class Request {
        @JsonbProperty(value="bucketfs_name")
        private final String bucketFsName;
        @JsonbProperty(value="bucket_name")
        private final String bucketName;
        @JsonbProperty(value="public")
        private final boolean isPublic;
        @JsonbProperty(value="read_password")
        private final String readPassword;
        @JsonbProperty(value="write_password")
        private final String writePassword;

        private Request(CreateBucketCommandBuilder builder) {
            this.bucketFsName = Objects.requireNonNull(builder.bucketFsName, "bucketFsName");
            this.bucketName = Objects.requireNonNull(builder.bucketName, "bucketName");
            this.isPublic = builder.isPublic;
            this.readPassword = Request.base64Encode(builder.readPassword);
            this.writePassword = Request.base64Encode(builder.writePassword);
        }

        private static String base64Encode(String value) {
            if (value == null) {
                return null;
            }
            return Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
        }

        public String getBucketFsName() {
            return this.bucketFsName;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public boolean isPublic() {
            return this.isPublic;
        }

        public String getReadPassword() {
            return this.readPassword;
        }

        public String getWritePassword() {
            return this.writePassword;
        }
    }
}

