/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.jsonrpc;

import com.exasol.bucketfs.jsonrpc.JsonRpcCommandExecutor;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import java.io.Reader;
import java.io.StringReader;

class JsonMapper {
    private final Jsonb jsonb;

    private JsonMapper(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    static JsonMapper create() {
        JsonbConfig config = new JsonbConfig().withFormatting(Boolean.valueOf(true));
        return new JsonMapper(JsonbBuilder.create((JsonbConfig)config));
    }

    String serialize(JsonRpcCommandExecutor.JsonRpcPayload payload) {
        return this.jsonb.toJson((Object)payload);
    }

    <T> T deserialize(String json, Class<T> type) {
        return (T)this.jsonb.fromJson(json, type);
    }

    JsonObject toJsonObject(Object parameters) {
        String json = this.jsonb.toJson(parameters);
        return this.parseJsonObject(json);
    }

    JsonObject parseJsonObject(String json) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    <T> T deserialize(JsonStructure json, Class<T> type) {
        return this.deserialize(json.toString(), type);
    }
}

