/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.list;

import com.exasol.bucketfs.BucketAccessException;
import com.exasol.bucketfs.BucketOperation;
import com.exasol.bucketfs.HttpResponseEvaluator;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Base64;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ListingRetriever {
    private static final Logger LOGGER = Logger.getLogger(ListingRetriever.class.getName());
    private final HttpClient httpClient;

    public static URI publicReadUri(String protocol, String host, int port, String suffix) {
        return URI.create(protocol + "://" + host + ":" + port + "/" + suffix);
    }

    public static String removeLeadingSeparator(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public ListingRetriever(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Stream<String> retrieve(URI uri, String readPassword) throws BucketAccessException {
        return Arrays.stream(this.requestListing(uri, readPassword).split("\\s+")).sorted();
    }

    private String requestListing(URI uri, String readPassword) throws BucketAccessException {
        LOGGER.finest(() -> "Listing contents of URI '" + uri + "'");
        try {
            HttpRequest request = HttpRequest.newBuilder(uri).header("Authorization", this.encodeBasicAuth(readPassword)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            HttpResponseEvaluator.evaluate(uri, BucketOperation.LIST, response.statusCode());
            return response.body();
        }
        catch (IOException exception) {
            throw BucketAccessException.downloadIoException(uri, BucketOperation.LIST, exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw BucketAccessException.downloadInterruptedException(uri, BucketOperation.LIST);
        }
    }

    private String encodeBasicAuth(String readPassword) {
        return "Basic " + Base64.getEncoder().encodeToString(("r:" + readPassword).getBytes());
    }
}

