/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs;

import com.exasol.bucketfs.BucketOperation;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.net.URI;

public class BucketAccessException
extends Exception {
    private static final long serialVersionUID = -1002852289020779835L;
    private final URI uri;
    private final int statusCode;

    public static BucketAccessException downloadInterruptedException(URI uri, BucketOperation operation) {
        return new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-4").message("Interrupted trying to {{operation|uq}} {{URI}}.", new Object[]{operation, uri}).toString());
    }

    public static BucketAccessException downloadIoException(URI uri, BucketOperation operation, IOException exception) {
        return new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-5").message("I/O error trying to {{operation|uq}} {{URI}}", new Object[]{operation, uri}).toString(), exception);
    }

    public BucketAccessException(String message, URI uri, Throwable cause) {
        super(message + " URI: " + uri, cause);
        this.uri = uri;
        this.statusCode = 0;
    }

    public BucketAccessException(String message, int statusCode, URI uri) {
        super(message + "URI: " + uri + " (Status " + statusCode + ")");
        this.statusCode = statusCode;
        this.uri = uri;
    }

    public BucketAccessException(String message, Throwable cause) {
        super(message, cause);
        this.uri = null;
        this.statusCode = 0;
    }

    public BucketAccessException(String message) {
        super(message);
        this.uri = null;
        this.statusCode = 0;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

