/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.config;

import com.exasol.config.BucketFsServiceConfiguration;

public class BucketConfiguration {
    private final String name;
    private final boolean publiclyReadable;
    private final String readPassword;
    private final String writePassword;
    private final BucketFsServiceConfiguration serviceConfiguration;

    private BucketConfiguration(Builder builder) {
        this.name = builder.name;
        this.publiclyReadable = builder.publiclyReadable;
        this.readPassword = builder.readPassword;
        this.writePassword = builder.writePassword;
        this.serviceConfiguration = builder.serviceConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public String getReadPassword() {
        return this.readPassword;
    }

    public String getWritePassword() {
        return this.writePassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isPubliclyReadable() {
        return this.publiclyReadable;
    }

    public BucketFsServiceConfiguration getBucketFsServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public static class Builder {
        private String name = "default";
        private boolean publiclyReadable = false;
        private String readPassword = null;
        private String writePassword = null;
        private BucketFsServiceConfiguration serviceConfiguration;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder readPassword(String readPassword) {
            this.readPassword = readPassword;
            return this;
        }

        public Builder writePassword(String writePassword) {
            this.writePassword = writePassword;
            return this;
        }

        public Builder publiclyReadable(boolean publiclyReadable) {
            this.publiclyReadable = publiclyReadable;
            return this;
        }

        public Builder bucketFsServiceConfiguration(BucketFsServiceConfiguration serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        public BucketConfiguration build() {
            return new BucketConfiguration(this);
        }
    }
}

