/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.http;

import com.exasol.bucketfs.http.FixedSANCertificate;
import com.exasol.bucketfs.http.SubjectAltName;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

class SubjectAltNameTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOGGER = Logger.getLogger(SubjectAltNameTrustManager.class.getName());
    private final X509ExtendedTrustManager delegate;
    private final List<SubjectAltName> alternativeNames;

    private SubjectAltNameTrustManager(X509ExtendedTrustManager delegate, List<SubjectAltName> altNames) {
        this.delegate = delegate;
        this.alternativeNames = altNames;
    }

    static TrustManager wrap(TrustManager delegate, List<SubjectAltName> altNames) {
        if (altNames.isEmpty()) {
            return delegate;
        }
        if (delegate instanceof X509ExtendedTrustManager) {
            LOGGER.info(() -> "Allow additional subject alternative names (SAN) " + String.valueOf(altNames) + " for certificate");
            return new SubjectAltNameTrustManager((X509ExtendedTrustManager)delegate, altNames);
        }
        throw new IllegalArgumentException("TrustManager of type " + delegate.getClass().getName() + " is not supported");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(this.addAlternativeNames(chain), authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkServerTrusted(this.addAlternativeNames(chain), authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.delegate.checkServerTrusted(this.addAlternativeNames(chain), authType, engine);
    }

    private X509Certificate[] addAlternativeNames(X509Certificate[] chain) {
        if (chain == null || chain.length < 1) {
            return chain;
        }
        LOGGER.finest(() -> "Modify Subject Alternative Name of first certificate to use " + String.valueOf(this.alternativeNames));
        FixedSANCertificate fixedSANCertificate = new FixedSANCertificate(chain[0], this.alternativeNames);
        return this.replaceFirstCertificate(chain, fixedSANCertificate);
    }

    private X509Certificate[] replaceFirstCertificate(X509Certificate[] chain, FixedSANCertificate fixedSANCertificate) {
        X509Certificate[] result = new X509Certificate[chain.length];
        System.arraycopy(chain, 0, result, 0, chain.length);
        result[0] = fixedSANCertificate;
        return result;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

