/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.jsonrpc;

import com.exasol.bucketfs.jsonrpc.JsonMapper;
import com.exasol.bucketfs.jsonrpc.JsonRpcException;
import com.exasol.bucketfs.jsonrpc.RpcCommand;
import com.exasol.errorreporting.ExaError;
import jakarta.json.JsonStructure;
import jakarta.json.bind.annotation.JsonbProperty;

abstract class AbstractJsonResponseCommand<R>
extends RpcCommand<R> {
    private static final String SUCCESS_RESULT_NAME = "OK";
    private static final int SUCCESS_RESULT_CODE = 0;
    protected final JsonMapper jsonMapper;

    protected AbstractJsonResponseCommand(JsonMapper jsonMapper, String jobName) {
        super(jobName);
        this.jsonMapper = jsonMapper;
    }

    @Override
    final R processResult(String responsePayload) {
        JsonRpcResponse payload = this.jsonMapper.deserialize(responsePayload, JsonRpcResponse.class);
        this.verifySuccess(payload);
        return this.processResult(payload.getOutput());
    }

    private void verifySuccess(JsonRpcResponse result) {
        if (this.hasErrorCode(result) || this.hasErrorDescription(result)) {
            throw new JsonRpcException(ExaError.messageBuilder((String)"E-BFSJ-18").message("RPC command {{command}} failed, received error result {{result}} from server.", new Object[]{this.getClass().getName(), result}).toString());
        }
    }

    private boolean hasErrorDescription(JsonRpcResponse result) {
        return !SUCCESS_RESULT_NAME.equalsIgnoreCase(result.getName());
    }

    private boolean hasErrorCode(JsonRpcResponse result) {
        return result.getCode() != 0;
    }

    abstract R processResult(JsonStructure var1);

    public static class JsonRpcResponse {
        @JsonbProperty(value="result_jobid")
        private String jobId;
        @JsonbProperty(value="result_code")
        private int code;
        @JsonbProperty(value="result_name")
        private String name;
        @JsonbProperty(value="result_desc")
        private String description;
        @JsonbProperty(value="result_revision")
        private int revision;
        @JsonbProperty(value="result_output")
        private JsonStructure output;

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getRevision() {
            return this.revision;
        }

        public void setRevision(int revision) {
            this.revision = revision;
        }

        public JsonStructure getOutput() {
            return this.output;
        }

        public void setOutput(JsonStructure output) {
            this.output = output;
        }

        public String toString() {
            return "Response [jobId=" + this.jobId + ", code=" + this.code + ", name=" + this.name + ", description=" + this.description + ", revision=" + this.revision + ", output=" + String.valueOf(this.output) + "]";
        }
    }
}

