/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.list;

import com.exasol.bucketfs.BucketAccessException;
import com.exasol.bucketfs.list.ListingRetriever;
import com.exasol.errorreporting.ExaError;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;

public class BucketService {
    private final ListingRetriever listingRetriever;
    private final URI bucketServiceUri;

    public BucketService(URI bucketServiceUri, ListingRetriever listingRetriever) {
        this.bucketServiceUri = bucketServiceUri;
        this.listingRetriever = listingRetriever;
    }

    public List<String> retrieve() throws BucketAccessException {
        List<String> list = this.listingRetriever.retrieve(this.bucketServiceUri, "").collect(Collectors.toList());
        if (list.isEmpty()) {
            throw new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-30").message("Unable to list buckets of {{bucket}}: No such file or directory.", new Object[]{this.bucketServiceUri}).toString());
        }
        return list;
    }
}

