/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.GeometryColumn;
import com.exasol.jdbc.HashtypeColumn;
import com.exasol.jdbc.IntervalDayColumn;
import com.exasol.jdbc.IntervalYearColumn;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.VarCharColumn;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class CharColumn
extends Column {
    protected String[] values;
    int octetLength = 0;

    CharColumn() {
        this.values = new String[initialBatchCapacity];
    }

    CharColumn(int maxWidth_) {
        this.values = new String[initialBatchCapacity];
        this.precision = maxWidth_;
    }

    CharColumn(int maxWidth_, int _maxOctetLength) {
        this.values = new String[initialBatchCapacity];
        this.precision = maxWidth_;
        this.octetLength = _maxOctetLength;
    }

    CharColumn(String name_, String[] values_) {
        super(name_);
        this.values = values_;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.precision >= this.values[i].length()) continue;
            this.precision = this.values[i].length();
        }
    }

    @Override
    int getPrecision() throws SQLException {
        return this.precision;
    }

    public void setMaxColumnSize(int p) {
        this.precision = p;
    }

    @Override
    String getClassName() {
        return "java.lang.String";
    }

    @Override
    int getDisplaySize() throws SQLException {
        return this.precision;
    }

    int getOctetLength() {
        return this.octetLength;
    }

    @Override
    int getType() {
        return 1;
    }

    @Override
    String getTypeName() {
        return "CHAR";
    }

    @Override
    Object getObject(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getObject: " + Translator.Accessed_null_value());
        }
        return this.values[row];
    }

    @Override
    String getString(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getString: " + Translator.Accessed_null_value());
        }
        return this.values[row];
    }

    @Override
    Time getTime(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getTime: " + Translator.Accessed_null_value());
        }
        return Time.valueOf(this.values[row]);
    }

    @Override
    boolean getBoolean(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getBoolean: " + Translator.Accessed_null_value());
        }
        if (this.values[row].trim().equalsIgnoreCase("1")) {
            return true;
        }
        if (this.values[row].trim().equalsIgnoreCase("0")) {
            return false;
        }
        if (this.values[row].trim().equalsIgnoreCase("Y")) {
            return true;
        }
        if (this.values[row].trim().equalsIgnoreCase("N")) {
            return false;
        }
        if (this.values[row].trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (this.values[row].trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new SQLException("CharColumn::getBoolean: " + Translator.Conversion_not_possible());
    }

    @Override
    byte getByte(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getByte: " + Translator.Accessed_null_value());
        }
        return Byte.parseByte(this.values[row]);
    }

    @Override
    double getDouble(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return Double.parseDouble(this.values[row]);
    }

    @Override
    float getFloat(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return Float.parseFloat(this.values[row]);
    }

    @Override
    int getInt(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getInt: " + Translator.Accessed_null_value());
        }
        return Integer.parseInt(this.values[row]);
    }

    @Override
    long getLong(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getLong: " + Translator.Accessed_null_value());
        }
        return Long.parseLong(this.values[row]);
    }

    @Override
    short getShort(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getShort: " + Translator.Accessed_null_value());
        }
        return Short.parseShort(this.values[row]);
    }

    @Override
    Timestamp getTimestamp(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getTimestamp: " + Translator.Accessed_null_value());
        }
        return Timestamp.valueOf(this.values[row]);
    }

    @Override
    Date getDate(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getDate: " + Translator.Accessed_null_value());
        }
        return Date.valueOf(this.values[row]);
    }

    @Override
    BigDecimal getBigDecimal(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("CharColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return new BigDecimal(this.values[row]);
    }

    @Override
    void resize(int size) {
        String[] nv = new String[size];
        boolean[] vm = new boolean[size];
        int s = this.values.length;
        if (s > size) {
            s = size;
        }
        for (int i = 0; i < s; ++i) {
            nv[i] = this.values[i];
            vm[i] = this.validMask[i];
        }
        for (int j = s; j < size; ++j) {
            vm[j] = false;
        }
        this.values = nv;
        this.validMask = vm;
    }

    static Column from_jdbc_type(EXAInputStream is, EXAConnection con, int type_code) throws IOException {
        byte varying = is.readByte();
        int width = is.readInt();
        int octetLength = is.readInt();
        switch (type_code) {
            case 17: {
                return new IntervalDayColumn(width, octetLength);
            }
            case 16: {
                return new IntervalYearColumn(width, octetLength);
            }
            case 126: {
                return new HashtypeColumn(width, octetLength);
            }
            case 123: {
                return new GeometryColumn(width, octetLength);
            }
        }
        if (1 == (varying & 1)) {
            return new VarCharColumn(width, octetLength);
        }
        return new CharColumn(width, octetLength);
    }

    @Override
    void setBigDecimal(int row, BigDecimal x) {
        this.setString(row, x.toString());
    }

    @Override
    void setBoolean(int row, boolean x) {
        this.setString(row, x ? "TRUE" : "FALSE");
    }

    @Override
    void setByte(int row, byte x) {
        this.setString(row, String.valueOf(x));
    }

    @Override
    void setDate(int row, Date x) {
        this.setString(row, x.toString());
    }

    @Override
    void setDouble(int row, double x) {
        this.setString(row, String.valueOf(x));
    }

    @Override
    void setFloat(int row, float x) {
        this.setString(row, String.valueOf(x));
    }

    @Override
    void setInt(int row, int x) {
        this.setString(row, String.valueOf(x));
    }

    @Override
    void setLong(int row, long x) {
        this.setString(row, String.valueOf(x));
    }

    @Override
    void setObject(int row, Object x) {
        this.setString(row, x.toString());
    }

    @Override
    void setShort(int row, short x) {
        this.setString(row, String.valueOf(x));
    }

    @Override
    void setString(int row, String x) {
        this.validMask[row] = true;
        if (x.length() > this.precision) {
            this.precision = x.length();
        }
        this.values[row] = x;
    }

    @Override
    void setTime(int row, Time x) {
        this.setString(row, x.toString());
    }

    @Override
    void setTimestamp(int row, Timestamp x) {
        this.setString(row, x.toString());
    }

    @Override
    void setNull(int row) {
        this.validMask[row] = false;
        this.values[row] = null;
    }

    @Override
    long value_to_jdbc(EXAOutputStream os, int row) throws SQLException, IOException {
        if (this.validMask[row]) {
            os.writeByte((byte)1);
            String v = this.values[row];
            if (v.length() > this.precision) {
                throw new SQLDataException(Translator.string_data_right_truncation() + ". StringLength " + v.length() + " > MaxLength " + this.precision + ". The string starts with: " + v.substring(0, 200 >= v.length() ? v.length() - 1 : 200), "001");
            }
            byte[] bytes = v.getBytes(os.getEncoding());
            os.writeInt(bytes.length);
            os.write(bytes);
            return 4 + bytes.length;
        }
        os.writeByte((byte)0);
        return 1L;
    }

    @Override
    void value_from_jdbc(EXAInputStream is, int row) throws SQLException, IOException {
        if (is.nextIsNull()) {
            this.validMask[row] = false;
        } else {
            this.values[row] = is.readString();
            this.validMask[row] = true;
        }
    }

    @Override
    int getEXAType() {
        return 10;
    }
}

