/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.InMessage;
import com.exasol.jdbc.OutMessage;
import com.exasol.jdbc.RecoverableOperation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLWarning;

public abstract class ServerCommunication {
    public static final String AUTOCOMMIT = "autocommit";
    public static final String FETCHSIZE = "fetchsize";
    public static final String SCHEMA = "schema";
    public static final String FINGERPRINT = "fingerprint";
    public static final String CLIENT_NAME = "clientname";
    public static final String CLIENT_VERSION = "clientversion";
    public static final String LOGINTIMEOUT = "logintimeout";
    public static final String HOSTTIMEOUT = "hosttimeout";
    public static final String ENCRYPTION = "encryption";
    public static final String QUERYTIMEOUT = "querytimeout";
    public static final String SUPERCONNECTION = "superconnection";
    public static final String FEEDBACKINTERVAL = "feedbackinterval";
    public static final String SNAPSHOTTRANSACTIONS = "snapshottransactions";
    public static final int SNAPSHOTTRANSACTIONS_DEFAULT = 2;
    public static final int SNAPSHOTTRANSACTIONS_ENABLE = 1;
    public static final int SNAPSHOTTRANSACTIONS_DISABLE = 0;
    public static final String DEFAULT_DATEFORMAT = "YYYY-MM-DD";
    public static final String DEFAULT_TIMESTAMPFORMAT = "YYYY-MM-DD HH:MI:SS.FF3";
    public static final String DEFAULT_NUMERIC_CHARACTERS = ".,";
    public static final String IGNOREPARAMS = "ignoreparams";
    public static final String KERBEROS_SERVICE_NAME = "kerberosservicename";
    public static final String KERBEROS_HOST_NAME = "kerberoshostname";
    public static final String KERBEROS_REALM = "kerberosrealm";
    public static final String KERBEROS_USER_NAME = "kerberosusername";
    public static final String KERBEROS_CONFIG_FILE = "kerberosconfig";
    public static final String KERBEROS_GSS_CONFIG_FILE = "kerberosgssconfig";
    public static final String LOGIN_TYPE = "logintype";
    public static final String TESTCONNECTIONSTRINGONLY = "TestConnectionStringOnly";
    public static final String CONNECTION_POOL_SIZE = "connectionPoolSize";
    public static final String WORKER = "worker";
    public static final String WORKER_TOKEN = "workertoken";
    public static final String METADATA_USE_SQL = "metadataSQL";
    public static final String DEBUG = "debug";
    public static final String USER_ID = "user";
    public static final String PASSWORD = "password";
    public static final String LOG_DIR = "logdir";
    public static final String AUTH_METHOD = "authmethod";
    public static final String VALIDATE_SERVER_CERTIFICATE = "validateservercertificate";
    public static final String USE_LEGACY_ENCRYPTION = "legacyencryption";
    public static final String SOCKET_FACTORY = "socketfactory";
    public static final String ENABLE_NUMERIC_TYPE_CONVERSION = "enablenumerictypeconversion";
    public static final String SOCKET_FACTORY_ARG = "socketfactoryarg";
    public static final String KEYSTORE = "keystore";
    public static final String KEYSTORE_PASSWORD = "keystorepassword";
    public static final String KEYSTORE_TYPE = "keystoretype";
    public static final String ON_CONNECT = "onconnect";
    protected ByteArrayOutputStream outData;
    protected EXAOutputStream outStream;
    protected byte[] tmpBytes;
    protected byte[] tmpBytes2;
    protected InMessage tmpInMessage;
    protected OutMessage tmpOutMessage;
    protected EXAResult[] tmpEXAResults;
    protected DebugLog debug;
    protected String className;
    protected EXAConnection connection;
    static int UNIQUE_ID = 0;
    int uid = ++UNIQUE_ID;
    private int reconnectWatcher = 0;

    protected int getObjectId() {
        return this.uid;
    }

    public ServerCommunication(DebugLog _debug, String myName, EXAConnection conn) {
        this.connection = conn;
        this.className = myName;
        this.debug = _debug;
        this.outData = new ByteArrayOutputStream();
        this.outStream = new EXAOutputStream(this.outData, this.connection);
        this.tmpBytes = null;
        this.tmpBytes2 = null;
        this.tmpInMessage = null;
        this.tmpOutMessage = null;
    }

    protected void logStackTrace(Throwable e) {
        StringBuffer sb = new StringBuffer();
        sb.append(e.toString()).append("\n");
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        this.log(sb.toString());
    }

    public DebugLog getDebug() {
        return this.debug;
    }

    public String getLogFileName() {
        if (this.debug != null) {
            return this.debug.getLogFileName();
        }
        return null;
    }

    public String getLogDirName() {
        if (this.debug != null) {
            return this.debug.getLogDirName();
        }
        return null;
    }

    public void clientLog(Object o) {
        this.log(o);
    }

    public void clientLogExternal(Object o) {
        if (this.debug != null) {
            this.debug.log(o.toString());
        }
    }

    protected void log(Object o) {
        if (this.debug != null) {
            this.debug.log(this.getObjectId() + " " + this.className + ": " + o.toString());
        }
    }

    protected void log(Object o, int level) {
        this.log(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(RecoverableOperation ro) throws IOException, SQLException {
        int tries = 0;
        do {
            StringWriter sw;
            ++tries;
            try {
                ro.op();
                return;
            }
            catch (IOException ex) {
                sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.log(" got IOException: " + ex.getMessage() + "\n" + sw.toString());
                this.connection.clearWarnings();
                try {
                    if (this.reconnectWatcher > 0) {
                        this.reconnectWatcher = 0;
                        throw new ConnectionException(ex.toString() + " Reconnect not possible, check for previous errors.");
                    }
                    ++this.reconnectWatcher;
                    this.connection.reconnect();
                }
                finally {
                    --this.reconnectWatcher;
                }
            }
            catch (ConnectionException | SQLInvalidAuthorizationSpecException ce) {
                sw = new StringWriter();
                ce.printStackTrace(new PrintWriter(sw));
                this.log(" got ConnectionException: " + ce.getSQLState() + " " + ce.getMessage() + "\n" + sw.toString());
                this.connection.clearWarnings();
                try {
                    if (this.reconnectWatcher > 0) {
                        this.reconnectWatcher = 0;
                        throw new ConnectionException(ce.toString() + " Reconnect not possible, check for previous errors.");
                    }
                    ++this.reconnectWatcher;
                    this.connection.reconnect();
                }
                finally {
                    --this.reconnectWatcher;
                }
            }
            SQLWarning warn = this.connection.getWarnings();
            if (warn == null) continue;
            this.connection.clearWarnings();
            throw warn;
        } while (tries < 2);
    }
}

